<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Products;
use App\Models\User;
use App\Models\Order;
use Illuminate\Http\JsonResponse;

use Laravel\Socialite\Facades\Socialite;
use App\Models\Cart;
use App\Models\Contact;

class WebController extends Controller
{
    public function about(){

        // $user=auth()->user()->id;
        if(Auth::Check()){
            $user=Auth::id();
            $cart=Cart::where('user_id',$user)->count();
            return view('about',compact('cart'));
        }
        return view('about');
   
       
    }

    public function hardware(){
        $products=Products::where('category','hardware')->get();
        if(Auth::Check()){
            $user=Auth::id();
            $cart=Cart::where('user_id',$user)->count();
            return view('testors',compact('cart','products'));
        }
        return view('testors',compact('products'));
   
       
    }
    public function clean(){
        $products=Products::where('category','clean')->get();
        if(Auth::Check()){
            $user=Auth::id();
            $cart=Cart::where('user_id',$user)->count();
            return view('personalgroming',compact('cart','products'));
        }
        return view('personalgroming',compact('products'));
   
       
    }
    public function aftershaves(){
        $products=Products::where('category','aftershaves')->get();
        if(Auth::Check()){
            $user=Auth::id();
            $cart=Cart::where('user_id',$user)->count();
            return view('aftershaves',compact('cart','products'));
        }
        return view('aftershaves',compact('products'));
   
       
    }

    public function admin(){

         $user=User::all();
        return view('admin.dashboard',compact('user'));
    }

    public function add_product(Request $req)
    {
        $products = new Products;
        $products->name = $req->title;
        $products->price = $req->price;
        $products->sizes = json_encode($req->sizes);

        $products->previous_price = $req->pr_price;
        $products->category = $req->category;
        $products->brand = $req->brand;
        $products->description = $req->description;
    
        // Handle main image
        if ($req->hasFile('image')) {
            $file = $req->file('image');
            $filename = 'main_' . time() . '.' . $file->getClientOriginalExtension(); 
            $destinationPath = 'uploads/products';
            
            if (!file_exists($destinationPath)) {
                mkdir($destinationPath, 0777, true);
            }
            
            $file->move($destinationPath, $filename); 
            $products->image = 'uploads/products/' . $filename;
        } else {
            return back()->with('error', 'Main image is required');
        }
    
        // Handle secondary image
        if ($req->hasFile('sec_image')) {
            $file = $req->file('sec_image');
            $filename = 'secondary_' . time() . '.' . $file->getClientOriginalExtension(); 
            $destinationPath = 'uploads/products';
            
            $file->move($destinationPath, $filename); 
            $products->second_image = 'uploads/products/' . $filename;
        }
    
        $products->save();
        session()->flash('success', 'Product created successfully');
        
        return redirect('admin/products');
    }

    public function all_product(){
        
      $products=Products::all();
      return view('admin.products',compact('products'));
         
    }

     public function getCategoryProducts($category): JsonResponse
    {
        $products = Products::where('category', $category)
            ->select('id', 'name', 'price', 'image')->get();
        
        return response()->json($products);
    }
    public function contact_form(Request $req){

        $contact=new Contact;
        $contact->name=$req->name;
        $contact->email=$req->email;
        $contact->subject=$req->subject;
        $contact->message=$req->message;
        $contact->save();
        session()->flash('success','Message Send Successfully');
        return redirect('/');

    }

    public function messages(){
        $msg=Contact::all();
        return view('admin.message',compact('msg'));
    }


    public function filteredOrders(Request $request)
{
    $query = Order::query();

    if ($request->filled('search')) {
        $search = strtolower($request->search);
        $query->where(function ($q) use ($search) {
            $q->whereRaw('LOWER(name) LIKE ?', ["%$search%"])
              ->orWhereRaw('LOWER(product_name) LIKE ?', ["%$search%"])
              ->orWhereRaw('LOWER(address) LIKE ?', ["%$search%"]);
        });
    }

    if ($request->filled('status')) {
        $query->where('status', $request->status);
    }

    if ($request->filled('payment_method')) {
        $query->where('payment_method', $request->payment_method);
    }

    if ($request->filled('start_date') && $request->filled('end_date')) {
        $query->whereBetween('created_at', [$request->start_date, $request->end_date]);
    }

    $orders = $query->latest()->get();

    return view('admin.order', compact('orders'));
}


    public function del_product($id){

        $product=Products::find($id);
        $product->delete();
        return redirect('/admin/products');
    }

    public function product_details($id) {
        $product = Products::find($id);
    
        if ($product) {
            $cart = 0;
    
            if (auth()->check()) {
                $user = auth()->id();
                $cart = Cart::where('user_id', $user)->count();
            }
    
            return view('product', compact('product', 'cart'));
        } else {
            return redirect()->route('home')->with('error', 'Product not found');
        }
    }
    

    public function contact_us(){
 
        return view('contact');
    }
    public function heat(){
   $products=Products::where('category','hardware')->get();
     
        if(Auth::Check()){
            $user=Auth::id();
            $cart=Cart::where('user_id',$user)->count();
            return view('allproducts',compact('cart','products'));
        }
        return view('allproducts',compact('products'));
   
       
    }


    

    public function create(){
        return view('admin.createproduct');
    }
    public function vapepods(){
        $products=Products::where('category','vapepods')->get();
        if(Auth::Check()){
            $user=Auth::id();
            $cart=Cart::where('user_id',$user)->count();
            return view('women',compact('cart','products'));
        }
        return view('women',compact('products'));
   
       
    }
   
    
    public function disposibles(){
        $products=Products::where('category','disposibles')->get();
        if(Auth::Check()){
            $user=Auth::id();
            $cart=Cart::where('user_id',$user)->count();
            return view('mens',compact('cart','products'));
        }
        return view('mens',compact('products'));
   
       
    }
       
    public function liquid(){
        $products=Products::where('category','liquid')->get();
        if(Auth::Check()){
            $user=Auth::id();
            $cart=Cart::where('user_id',$user)->count();
            return view('giftset',compact('cart','products'));
        }
        return view('giftset',compact('products'));
   
       
    }


    public function orders(){
        $orders = Order::with('items')->latest()->get();
        return view('admin.order',compact('orders'));
    }

    public function edit_product($id){
      
        $product=Products::find($id);
        if($product){

            return view('admin.createproduct',compact('product'));
        }
    }

    public function update_product(Request $request, $id)
    {

        $product = Products::findOrFail($id);
        $product->name = $request->title;
        $product->price = $request->price;
        $product->brand = $request->brand;
        $product->previous_price = $request->pr_price;
        $product->category = $request->category;
        $product->description = $request->description;
        $product->sizes = json_encode($request->sizes ?? []);
        if ($request->hasFile('image')) {
            $imageName = time().'_main.'.$request->image->extension();
            $request->image->move('uploads', $imageName);
            $product->image = 'uploads/' . $imageName;
        }

        if ($request->hasFile('sec_image')) {
            $secImageName = time().'_sec.'.$request->sec_image->extension();
            $request->sec_image->move('uploads', $secImageName);
            $product->sec_image = 'uploads/' . $secImageName;
        }
        $product->save();
    
        return redirect('/admin/products');
    }
    

    public function search(Request $request)
{
    $query = $request->get('q'); // jo search box se aa raha hai
    
    $products = Products::where('name', 'LIKE', "%{$query}%")
                        ->take(5) // sirf 5 results dikhao (fast ke liye)
                        ->get();

    return response()->json($products);
}

    
public function redirectToGoogle()
{
    return Socialite::driver('google')->redirect();
}

public function handleGoogleCallback()
{
  
    $googleUser = Socialite::driver('google')->stateless()->user();

    // Laravel login logic
    $findUser = User::where('email', $googleUser->getEmail())->first();

    if ($findUser) {
        Auth::login($findUser);
    } else {
        $newUser = User::create([
            'name'      => $googleUser->getName(),
            'email'     => $googleUser->getEmail(),
            'google_id' => $googleUser->getId(),
            'password'  => bcrypt(uniqid()),  // dummy password
        ]);

        Auth::login($newUser);
    }

    return redirect()->intended('dashboard');
}
function privacypolicy(){
    return view('privacypolicy');
}

function shippingpolicy(){
    return view('shippingpolicy');
}
function returnsrefunds(){
    return view('returnsrefunds');
}
function termsconditions(){
    return view('termsconditions');
}
}
