<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Log;

class LogApiRequests
{
    public function handle($request, Closure $next)
    {
        Log::channel('stripe')->info('API Request', [
            'url' => $request->fullUrl(),
            'method' => $request->method(),
            'ip' => $request->ip(),
            'user_id' => auth()->id()
        ]);
        
        $response = $next($request);
        
        Log::channel('stripe')->info('API Response', [
            'status' => $response->status(),
            'content' => $response->getContent()
        ]);
        
        return $response;
    }
}
