<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Perfumes canada</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="{{ asset('assets/images/logg.png') }}" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{ asset('frontend/assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/aos/aos.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">
  
  <!-- Main CSS File -->
  <link href="{{ asset('frontend/assets/css/main.css') }}" rel="stylesheet">
  

  <!-- =======================================================
  * Template Name: Presento
  * Template URL: https://bootstrapmade.com/presento-bootstrap-corporate-template/
  * Updated: Aug 07 2024 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="index-page">

  
  
  <!-- CSS for Larger Floating WhatsApp Button -->
  <style>
    .whatsapp-button {
      position: fixed;
      bottom: 110px; /* Adjust the distance from the bottom */
      right: 20px; /* Adjust the distance from the right */
      z-index: 1000; /* Ensure it stays on top of other elements */
      background-color: #25d366; /* WhatsApp green color */
      border-radius: 50%; /* Make it circular */
      padding: 15px; /* Increased padding for larger size */
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2); /* Add a subtle shadow */
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
  
    .whatsapp-button:hover {
      transform: scale(1.1); /* Slightly enlarge on hover */
      box-shadow: 0 6px 15px rgba(0, 0, 0, 0.3); /* Enhance shadow on hover */
    }
  
    .whatsapp-button img {
      display: block;
      width: 60px; /* Increased icon size */
      height: 60px; /* Increased icon size */
    }
  </style>
<header class="header bg-white pb-0">
  <div class="topbar container d-flex justify-content-between align-items-center py-2 px-3">

    <!-- Left: Logo -->
    <a href="/" class="logo">
      <img src="{{ asset('assets/logo.png') }}" alt="Logo" class="img-fluid" style="height: 70px;">
    </a>

    <!-- Right Side: Search + Cart + Toggler -->






      <!-- Desktop Cart -->
      <div class="d-none d-md-flex align-items-center me-3">
         
           <a href="/" class="position-relative ms-3" style="color: black; text-decoration: none;">
                Welcome To Our Shop
              
            </a>
              <a href="/" class="position-relative ms-3" style="color: white; background:#D4AF37; border-radius:20px;padding:15px; text-decoration: none;">
                104 Dundas St E, Toronto, ON M5B 1C9
              
            </a>
      <a href="/cart" class="position-relative ms-3" style="color: black; text-decoration: none;">
                <i class="bi bi-cart3 fs-5"></i>
                <span class="badge bg-danger position-absolute top-0 start-100 translate-middle rounded-pill">
                    {{ $cartCount }}
                </span>
            </a>
      </div>

      <!-- Mobile Cart + Toggler -->
      <div class="d-md-none d-flex align-items-center">
       <a href="/cart" class="position-relative me-3" style="color: black; text-decoration: none;">
                <i class="bi bi-cart3 fs-5"></i>
                <span class="badge bg-danger position-absolute top-0 start-100 translate-middle rounded-pill">
                    {{ $cartCount }}
                </span>
            </a>
        <button class="navbar-toggler text-dark border-0 bg-transparent p-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
          <i class="bi bi-list fs-4"></i>
        </button>
      </div>
    </div>
  </div>

  <!-- Navigation -->
  <nav class="navbar navbar-expand-md">
    <div class="container-fluid px-0">
      <div class="collapse navbar-collapse" id="navbarCollapse">
        <ul class="navbar-nav w-100 justify-content-center flex-wrap py-2 m-0">
          <li class="nav-item"><a class="nav-link " href="/">Home</a></li>
       
          <li class="nav-item"><a class="nav-link" href="/disposibles">disposibles</a></li>
          <li class="nav-item"><a class="nav-link" href="/vapepods">Vape Pods</a></li>
          <li class="nav-item"><a class="nav-link" href="/heat">Heat-Not Burn</a></li>
          <li class="nav-item"><a class="nav-link" href="/liquid">E-Liquid</a></li>
          <li class="nav-item"><a class="nav-link" href="/hardware">Hardware</a></li>
          <li class="nav-item"><a class="nav-link" href="/clean">CLearance</a></li>
          <li class="nav-item"><a class="nav-link" href="/contactus">Contact</a></li>
        </ul>
      </div>
    </div>
  </nav>
</header>


  <main class="main">

   
    <section id="hero" class="hero-section">
        <div class="hero-container">
          <div class="hero-background">
            <img src="{{asset('assets/images/abf.png')}}" alt="Luxury Perfume Collection" class="hero-image" data-aos="fade-in">
            <div class="overlay"></div>
          </div>
          
          <div class="hero-content" data-aos="fade-up">
            {{-- <div class="container">
              <div class="row justify-content-center">
                <div class="col-lg-8 text-center">
                  <h1 class="hero-title" data-aos="fade-up" data-aos-delay="100">Essence of Timeless Luxury</h1>
                  <p class="hero-subtitle" data-aos="fade-up" data-aos-delay="150">Where Memories Become Fragrance</p>
                  <div class="divider" data-aos="fade-up" data-aos-delay="200"></div>
                  <p class="hero-description" data-aos="fade-up" data-aos-delay="200">
                    Each creation in our atelier is a symphony of rare essences, meticulously blended by master perfumers. 
                    From the first delicate top notes to the profound base that lingers on your skin, we craft not just scents 
                    but olfactory narratives that become your invisible signature.
                  </p>
                  <div class="hero-cta" data-aos="fade-up" data-aos-delay="300">
                    <a href="/allproducts" class="btn-explore">Experience the Collection</a>
                    <a href="#about" class="btn-discover ml-3">The Art of Perfumery</a>
                  </div>
                </div>
              </div>
            </div> --}}
          </div>
        </div>
      </section>
      
      <style>
      .hero-section {
        padding-top: 0px;
        position: relative;
        height: 100vh;
        min-height: 900px;
        overflow: hidden;
      }
      
      .hero-container {
        position: relative;
        height: 100%;
      }
      
      .hero-background {
        position: absolute;
        width: 100%;
        height: 100%;
      }
      
      .hero-image {
        width: 100%;
        height: 100%;
        object-fit: cover;
      }
      
      .overlay {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;

      }
      
      .hero-content {
        position: relative;
        z-index: 2;
        display: flex;
        align-items: center;
        height: 100%;
        color: #fff;
        text-shadow: 1px 1px 3px rgba(0,0,0,0.3);
      }
      
      .hero-title {
        font-size: 4rem;
        font-weight: 300;
        letter-spacing: 2px;
        margin-bottom: 0.5rem;
        color: white;
        text-transform: uppercase;
      }
      
      .hero-subtitle {
        font-size: 1.5rem;
        font-weight: 300;
        letter-spacing: 4px;
        margin-bottom: 1.5rem;
      }
      
      .divider {
        width: 80px;
        height: 2px;
        background: #fff;
        margin: 1.5rem auto;
        opacity: 0.7;
      }
      
      .hero-description {
        font-size: 1.1rem;
        max-width: 700px;
        margin: 0 auto 2rem;
        line-height: 1.8;
        opacity: 0.9;
      }
      
      .btn-explore, .btn-discover {
        padding: 12px 30px;
        border-radius: 30px;
        font-weight: 500;
        letter-spacing: 1px;
        text-transform: uppercase;
        transition: all 0.3s ease;
      }
      
      .btn-explore {
        background: #fff;
        color: #3a0a3a;
        border: 2px solid #fff;
      }
      
      .btn-explore:hover {
        background: transparent;
        color: #fff;
      }
      
      .btn-discover {
        background: transparent;
        color: #fff;
        border: 2px solid #fff;
      }
      
      .btn-discover:hover {
        background: #fff;
        color: #3a0a3a;
      }
      
      @media (max-width: 768px) {
        .hero-title {
          font-size: 2.5rem;
        }
        
        .hero-subtitle {
          font-size: 1.2rem;
        }
        
        .hero-cta {
          display: flex;
          flex-direction: column;
        }
        
        .btn-discover {
          margin-left: 0 !important;
          margin-top: 15px;
        }
      }
      </style>
    
     
    

    <!-- Why Choose Our Products Section -->
  <!-- Pricing Section -->
  <section id="choose-us" class="pricing section section-bg dark-background">

    <!-- Section Title -->
    <div class="container section-title" data-aos="fade-up">
      <h2>Why Choose Perfumes Canada</h2>
      <p>Experience the finest fragrances crafted with passion, quality, and lasting impressions.</p>
    </div><!-- End Section Title -->
  
    <div class="container">
      <div class="row g-4 g-lg-0">
  
        <!-- Perfume Quality -->
        <div class="col-lg-4" data-aos="zoom-in" data-aos-delay="100">
          <div class="pricing-item">
            <h3>Premium Quality</h3>
            <ul>
              <li><i class="bi bi-check"></i> <span>Long-lasting fragrances</span></li>
              <li><i class="bi bi-check"></i> <span>High-end ingredients</span></li>
              <li><i class="bi bi-check"></i> <span>Elegant & safe packaging</span></li>
              <li><i class="bi bi-check"></i> <span>Tested & trusted</span></li>
            </ul>
          </div>
        </div>
  
        <!-- Variety -->
        <div class="col-lg-4 featured" data-aos="zoom-in" data-aos-delay="200">
          <div class="pricing-item">
            <h3>Wide Range for Everyone</h3>
            <ul>
              <li><i class="bi bi-check"></i> <span>Men & Women collections</span></li>
              <li><i class="bi bi-check"></i> <span>Gift sets available</span></li>
              <li><i class="bi bi-check"></i> <span>Classic & modern blends</span></li>
              <li><i class="bi bi-check"></i> <span>Seasonal exclusives</span></li>
            </ul>
          </div>
        </div>
  
        <!-- Customer Trust -->
        <div class="col-lg-4" data-aos="zoom-in" data-aos-delay="300">
          <div class="pricing-item">
            <h3>Trusted by Customers</h3>
            <ul>
              <li><i class="bi bi-check"></i> <span>Fast & secure delivery</span></li>
              <li><i class="bi bi-check"></i> <span>Excellent customer support</span></li>
              <li><i class="bi bi-check"></i> <span>Hassle-free returns</span></li>
              <li><i class="bi bi-check"></i> <span>Great reviews & feedback</span></li>
            </ul>
          </div>
        </div>
  
      </div>
    </div>
  
  </section><!-- /Choose Us Section -->
  


<!-- About Section -->
<section id="about" class="about section section-bg dark-background">

  <div class="container position-relative">

    <div class="row gy-5">

      <div class="content col-xl-5 d-flex flex-column" data-aos="fade-up" data-aos-delay="100">
        <h3>Elegance in Every Bottle</h3>
        <p>
          Discover our hand-picked collection of premium fragrances, crafted to elevate your presence and leave a lasting impression. Designed for those who appreciate true luxury.
        </p>
        <a href="{{ route('allproducts') }}" class="about-btn align-self-center align-self-xl-start"><span>Explore More</span> <i class="bi bi-chevron-right"></i></a>
      </div>

      <div class="col-xl-7" data-aos="fade-up" data-aos-delay="200">
        <div class="row gy-4">

          <div class="col-md-6 icon-box position-relative">
            <i class="bi bi-flower1"></i>
            <h4><a href="#" class="stretched-link">Unique Fragrance Notes</a></h4>
            <p>From floral to woody, our perfumes are designed with rich layers that suit every personality and occasion.</p>
          </div>

          <div class="col-md-6 icon-box position-relative">
            <i class="bi bi-gift"></i>
            <h4><a href="#" class="stretched-link">Perfect Gift Option</a></h4>
            <p>Elegant packaging and unforgettable scents make our perfumes the perfect gift for loved ones.</p>
          </div>

          <div class="col-md-6 icon-box position-relative">
            <i class="bi bi-truck"></i>
            <h4><a href="#" class="stretched-link">Fast & Safe Delivery</a></h4>
            <p>We ensure your perfumes are delivered securely and quickly — fresh and ready to wear.</p>
          </div>

          <div class="col-md-6 icon-box position-relative">
            <i class="bi bi-star"></i>
            <h4><a href="#" class="stretched-link">Satisfaction Guaranteed</a></h4>
            <p>Our commitment to quality means you receive only the finest perfumes backed by trusted customer reviews.</p>
          </div>

        </div>
      </div>

    </div>

  </div>

</section>
<!-- /About Section -->


<!-- Stats Section -->
<section id="stats" class="stats section">

  <div class="container" data-aos="fade-up" data-aos-delay="100">

    <div class="row gy-4">

      <div class="col-lg-3 col-md-6 d-flex flex-column align-items-center">
        <i class="bi bi-emoji-heart-eyes"></i>
        <div class="stats-item">
          <span data-purecounter-start="0" data-purecounter-end="1500" data-purecounter-duration="1" class="purecounter"></span>
          <p>Satisfied Customers</p>
        </div>
      </div><!-- End Stats Item -->

      <div class="col-lg-3 col-md-6 d-flex flex-column align-items-center">
        <i class="bi bi-droplet-half"></i>
        <div class="stats-item">
          <span data-purecounter-start="0" data-purecounter-end="3000" data-purecounter-duration="1" class="purecounter"></span>
          <p>Fragrances Delivered</p>
        </div>
      </div><!-- End Stats Item -->

      <div class="col-lg-3 col-md-6 d-flex flex-column align-items-center">
        <i class="bi bi-headset"></i>
        <div class="stats-item">
          <span data-purecounter-start="0" data-purecounter-end="1000" data-purecounter-duration="1" class="purecounter"></span>
          <p>Support Hours</p>
        </div>
      </div><!-- End Stats Item -->

      <div class="col-lg-3 col-md-6 d-flex flex-column align-items-center">
        <i class="bi bi-person-bounding-box"></i>
        <div class="stats-item">
          <span data-purecounter-start="0" data-purecounter-end="15" data-purecounter-duration="1" class="purecounter"></span>
          <p>Expert Perfumers</p>
        </div>
      </div><!-- End Stats Item -->

    </div>

  </div>

</section>
<!-- /Stats Section -->


   

    <!-- Services Section -->
  

  

 
    
<!-- Testimonials Section -->
<section id="testimonials" class="testimonials section">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <h2>Testimonials</h2>
    <p>Hear from fragrance lovers who found their signature scent with us</p>
  </div><!-- End Section Title -->

  <div class="container" data-aos="fade-up" data-aos-delay="100">

    <div class="swiper init-swiper">
      <script type="application/json" class="swiper-config">
        {
          "loop": true,
          "speed": 600,
          "autoplay": { "delay": 5000 },
          "slidesPerView": "auto",
          "pagination": {
            "el": ".swiper-pagination",
            "type": "bullets",
            "clickable": true
          },
          "breakpoints": {
            "320": { "slidesPerView": 1, "spaceBetween": 40 },
            "1200": { "slidesPerView": 3, "spaceBetween": 20 }
          }
        }
      </script>
      <div class="swiper-wrapper">

        <!-- Testimonial 1 -->
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <h3>Emma Clarke</h3>
            <h4>Fragrance Enthusiast</h4>
            <div class="stars mb-2">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-half"></i>
            </div>
            <p>
              <i class="bi bi-quote quote-icon-left"></i>
              I fell in love with the Velvet Rose scent—it’s so elegant and long‑lasting! Every compliment I get reminds me of how special this perfume is.
              <i class="bi bi-quote quote-icon-right"></i>
            </p>
          </div>
        </div>

        <!-- Testimonial 2 -->
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <h3>Michael Duran</h3>
            <h4>Perfume Collector</h4>
            <div class="stars mb-2">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-half"></i><i class="bi bi-star"></i>
            </div>
            <p>
              <i class="bi bi-quote quote-icon-left"></i>
              Their Oud Mystique is unlike anything I’ve tried—rich, complex, and the sillage is incredible. A must‑have for any collector!
              <i class="bi bi-quote quote-icon-right"></i>
            </p>
          </div>
        </div>

        <!-- Testimonial 3 -->
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <h3>Sofia Martinez</h3>
            <h4>Beauty Blogger</h4>
            <div class="stars mb-2">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
            </div>
            <p>
              <i class="bi bi-quote quote-icon-left"></i>
              I featured their Citrus Bloom on my blog and it was an instant hit—fresh, playful, and perfect for spring mornings.
              <i class="bi bi-quote quote-icon-right"></i>
            </p>
          </div>
        </div>

        <!-- Testimonial 4 -->
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <h3>Liam Chen</h3>
            <h4>Style Influencer</h4>
            <div class="stars mb-2">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-half"></i>
            </div>
            <p>
              <i class="bi bi-quote quote-icon-left"></i>
              The Midnight Ember fragrance has become my signature after‑dark scent—smoky, sensual, and perfect for evenings out.
              <i class="bi bi-quote quote-icon-right"></i>
            </p>
          </div>
        </div>

        <!-- Testimonial 5 -->
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <h3>Ava Patel</h3>
            <h4>Regular Client</h4>
            <div class="stars mb-2">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
            </div>
            <p>
              <i class="bi bi-quote quote-icon-left"></i>
              I subscribe to their monthly perfume box and never run out of my favorites. It’s such a delight to discover new scents every month!
              <i class="bi bi-quote quote-icon-right"></i>
            </p>
          </div>
        </div>

      </div>
      <div class="swiper-pagination"></div>
    </div>

  </div>

</section><!-- /Testimonials Section -->
    

   

  </main>

  <footer id="footer" class="footer dark-background py-5">
    <div class="container footer-top">
      <div class="row gy-4">
  
        <!-- Column 1: About -->
        <div class="col-lg-3 col-md-6 footer-about">
          <a href="/" class="logo d-flex align-items-center mb-2">
            <span class="sitename">Perfumes Canada</span>
          </a>
          <p>Your destination for luxury fragrances, gift sets, and exclusive collections across Canada. Discover your scent today!</p>
          <div class="footer-contact pt-3">
            <p> Bramtpon , ON </p>
            <p class="mt-3"><strong>Phone:</strong> <span>+1 905-467-9828</span></p>
          </div>
        </div>
  
        <!-- Column 2: Links -->
        <div class="col-lg-3 col-md-6 footer-links">
          <h4>Explore</h4>
          <ul>
            <li><a href="/">Home</a></li>
            <li><a href="{{ route('about') }}">About Us</a></li>
            <li><a href="/men">Mens</a></li>
            <li><a href="/women">Womens</a></li>
            <li><a href="/giftset">Gift Sets</a></li>
            <li><a href="{{ route('allproducts') }}">Full Catalog</a></li>
          </ul>
        </div>
  
        <!-- Column 3: Images -->
        <div class="col-lg-3 col-md-6">
          <h4>Featured</h4>
          <div class="d-flex flex-wrap gap-2">
            <img src="{{ asset('assets/images/giftset.png') }}" alt="Perfume 1" style="width: 60px; height: 60px; object-fit: cover; border-radius: 8px;">
            <img src="{{ asset('assets/images/dor.avif') }}" alt="Perfume 2" style="width: 60px; height: 60px; object-fit: cover; border-radius: 8px;">
            <img src="{{ asset('assets/images/womenimg.png') }}" alt="Perfume 1" style="width: 60px; height: 60px; object-fit: cover; border-radius: 8px;">
          </div>
        </div>
  
        <!-- Column 4: Newsletter -->
        <div class="col-lg-3 col-md-6 footer-newsletter">
          <h4>Our Newsletter</h4>
          <p>Subscribe to our newsletter and receive the latest news about our products and services!</p>
          <!-- Optional form or button can be added here -->
        </div>
  
      </div>
    </div>
  
    <div class="container copyright text-center mt-4">
      <p>© <strong class="px-1 sitename">Perfumes Canada</strong> | All Rights Reserved</p>
      <div class="credits">
        Designed by <a href="https://bizzsofts.com/">bizzsofts Development</a>
      </div>
    </div>
  </footer>
  

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="{{ asset('frontend/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/php-email-form/validate.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/aos/aos.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/purecounter/purecounter_vanilla.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
  
  <!-- Main JS File -->
  <script src="{{ asset('frontend/assets/js/main.js') }}"></script>
  

</body>

</html>