@extends('admin.master')

@section('main')
<div class="container mt-3 mt-md-5">
    <div class="card shadow-lg rounded">
        <div class="card-header bg-dark text-white">
            <h3 class="mb-0">👤 User Details</h3>
        </div>
        <div class="card-body p-0 p-md-4">
            <div class="table-responsive">
                <table class="table table-hover align-middle mb-0">
                    <thead class="table-light">
                        <tr>
                            <th class="text-uppercase">Name</th>
                            <th class="text-uppercase">Email</th>
                            <th class="text-uppercase">Role</th>
                            <th class="text-uppercase">Created At</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($user as $user)
                        <tr>
                            <td data-label="Name" class="d-md-table-cell"><strong>{{ $user->name }}</strong></td>
                            <td data-label="Email" class="d-md-table-cell">{{ $user->email }}</td>
                            <td data-label="Role" class="d-md-table-cell">
                                <span class="badge bg-secondary text-white">
                                    {{ $user->user_type ?? 'N/A' }}
                                </span>
                            </td>
                            <td data-label="Created" class="d-md-table-cell">{{ $user->created_at->format('d M Y') }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<style>
    /* Responsive table styles */
    .table-responsive {
        overflow-x: auto;
        -webkit-overflow-scrolling: touch;
    }
    
    @media (max-width: 767.98px) {
        /* Hide table headers on mobile */
        table thead {
            display: none;
        }
        
        /* Make table rows behave like blocks */
        table tr {
            display: block;
            margin-bottom: 1rem;
            border-bottom: 2px solid #dee2e6;
        }
        
        /* Style table cells for mobile */
        table td {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.5rem;
            text-align: right;
            border-bottom: 1px solid #eee;
        }
        
        /* Add data-label pseudo-elements */
        table td:before {
            content: attr(data-label);
            font-weight: bold;
            text-transform: uppercase;
            margin-right: 1rem;
        }
        
        /* Remove last border */
        table td:last-child {
            border-bottom: 0;
        }
    }
</style>
@endsection