@extends('admin.master')

@if(session('success'))
    <script>
        alert("{{ session('success') }}");
    </script>
@endif

@section('main')
<div class="container mt-5">
    <!-- Search Bar -->
    <div class="row mb-4">
        <div class="col-md-6">
            <div class="input-group mb-3">
                <input type="text" id="nameSearch" class="form-control" placeholder="Search by name...">
                <button class="btn btn-outline-secondary" type="button" id="searchByNameBtn">
                    <i class="bi bi-search"></i>
                </button>
            </div>
        </div>
        <div class="col-md-6">
            <div class="input-group mb-3">
                <select class="form-select" id="categorySearch">
                    <option value="">All Categories</option>
                    <option value="men">Men</option>
                    <option value="women">Women</option>
                    <option value="giftset">Gift Sets</option>
                    <option value="others">Others</option>
                </select>
                <button class="btn btn-outline-secondary" type="button" id="searchByCategoryBtn">
                    <i class="bi bi-filter"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Products Grid -->
    <div class="row" id="productsContainer">
        @forelse($products as $product)
            <div class="col-md-4 mb-4 product-card" data-name="{{ strtolower($product->name) }}" data-category="{{ strtolower($product->category) }}">
                <div class="card h-100">
                    <img src="{{ asset($product->image) }}" style="height: 300px; object-fit: cover;" class="card-img-top" alt="Product Image">
                    <div class="card-body">
                        <h5 class="card-title">{{ $product->name }}</h5>
                        <p class="card-text">{{ $product->price }} $</p>
                        <p class="text-muted"><small>{{ ucfirst($product->category) }}</small></p>
                        <form action="{{ route('del_product', $product->id) }}" method="POST" style="margin-top: 20px">
                            @csrf
                            <button class="btn btn-warning">Delete Product</button>
                        </form>
                        <a href="{{route('edit_product',$product->id)}}" style="margin-top: 20px">
                        <button class="btn btn-success">Edit Product</button>
                    </a>
                    </div>
                </div>
            </div>
        @empty
            <div class="col-12 text-center">
                <h4>No products found.</h4>
            </div>
        @endforelse
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const nameSearch = document.getElementById('nameSearch');
    const categorySearch = document.getElementById('categorySearch');
    const searchByNameBtn = document.getElementById('searchByNameBtn');
    const searchByCategoryBtn = document.getElementById('searchByCategoryBtn');
    const productCards = document.querySelectorAll('.product-card');
    
    // Search by name
    searchByNameBtn.addEventListener('click', filterProducts);
    nameSearch.addEventListener('keyup', function(e) {
        if (e.key === 'Enter') filterProducts();
    });
    
    // Search by category
    searchByCategoryBtn.addEventListener('click', filterProducts);
    categorySearch.addEventListener('change', filterProducts);
    
    function filterProducts() {
        const nameTerm = nameSearch.value.toLowerCase();
        const categoryTerm = categorySearch.value.toLowerCase();
        let hasResults = false;
        
        productCards.forEach(card => {
            const cardName = card.dataset.name;
            const cardCategory = card.dataset.category;
            const nameMatch = cardName.includes(nameTerm);
            const categoryMatch = categoryTerm === '' || cardCategory === categoryTerm;
            
            if (nameMatch && categoryMatch) {
                card.style.display = 'block';
                hasResults = true;
            } else {
                card.style.display = 'none';
            }
        });
        
        // Show no results message if needed
        const noResultsMsg = document.querySelector('.no-results-msg');
        if (!hasResults) {
            if (!noResultsMsg) {
                const msgDiv = document.createElement('div');
                msgDiv.className = 'col-12 text-center no-results-msg';
                msgDiv.innerHTML = '<h4>No products match your search criteria.</h4>';
                document.getElementById('productsContainer').appendChild(msgDiv);
            }
        } else if (noResultsMsg) {
            noResultsMsg.remove();
        }
    }
});
</script>

<style>
    .product-card {
        transition: all 0.3s ease;
    }
    
    .product-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 10px 20px rgba(0,0,0,0.1);
    }
    
    .card {
        border-radius: 10px;
        overflow: hidden;
        border: 1px solid rgba(0,0,0,0.1);
    }
    
    .card-img-top {
        transition: transform 0.3s ease;
    }
    
    .card:hover .card-img-top {
        transform: scale(1.03);
    }
    
    .btn-warning {
        background-color: #ffc107;
        border-color: #ffc107;
        transition: all 0.3s ease;
    }
    
    .btn-warning:hover {
        background-color: #e0a800;
        border-color: #d39e00;
        transform: translateY(-2px);
    }
</style>

@endsection