<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Captain Vape</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="{{ asset('assets/images/logg.png') }}" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-pVrmAqHnV5v4RszFqV0XQvQn7o3b1n6oGv8y2rYqYVf8z8+Y6v9h3UOZ9zW9nGZrJ3VJ9oS3/1N6jL1d6x9Ypg==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <link href="{{ asset('frontend/assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/aos/aos.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">
  
  <!-- Main CSS File -->
  <link href="{{ asset('frontend/assets/css/main.css') }}" rel="stylesheet">
</head>

<body class="index-page">
    <!-- WhatsApp Button -->
  
      
  @include('header')

<main class="main">
    <div class="container py-5">
        <div class="row">
            <!-- Cart Items Section -->
            <div class="col-lg-8">
                <div class="card shadow-sm border-0" style="border-color: #D4AF37 !important;">
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between align-items-center mb-4">
                            <h2 class="fw-bold mb-0" style="color: #996515;">
                                <i class="bi bi-cart3 me-2" style="color: #D4AF37;"></i> Your Shopping Cart
                            </h2>
                            <span class="badge rounded-pill" style="background-color: #D4AF37;">
                                {{ count($cartItems) }} {{ count($cartItems) > 1 ? 'Items' : 'Item' }}
                            </span>
                        </div>
    
                        @if(session('success'))
                            <div class="alert alert-success alert-dismissible fade show">
                                {{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif
    
                        @if(count($cartItems) > 0)
                            <div class="table-responsive">
                                <table class="table align-middle">
                                    <thead style="background-color: #F5E7C1;">
                                        <tr>
                                            <th style="width: 45%; color: #996515;">Product</th>
                                            <th class="text-center" style="color: #996515;">Size</th>
                                            <th class="text-end" style="color: #996515;">Price</th>
                                            <th class="text-center" style="color: #996515;">Quantity</th>
                                            <th class="text-end" style="color: #996515;">Total</th>
                                            <th class="text-end" style="color: #996515;">Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($cartItems as $id => $item)
                                        <tr class="product-row align-middle">
                                            <td>
                                                <div class="d-flex align-items-center">
                                                    <div class="rounded-3 overflow-hidden border" style="width: 80px; height: 80px; background: #F5E7C1; border-color: #D4AF37 !important;">
                                                        <img src="{{ asset($item['image']) }}" alt="{{ $item['name'] }}" class="img-fluid h-100 w-100 object-fit-cover">
                                                    </div>
                                                    <div class="ms-3">
                                                        <h6 class="mb-1" style="color: #996515;">{{ $item['name'] }}</h6>
                                                        <small class="text-muted">SKU: {{ $item['sku'] ?? 'N/A' }}</small>
                                                    </div>
                                                </div>
                                            </td>
                                            <td class="text-end fw-semibold" style="color: #996515;">
                                                {{ $item['size'] ?? '-' }}
                                            </td>
                                            <td class="text-end" style="color: #996515;">
                                                ${{ number_format($item['price'], 2) }}<br>
                                                @if(isset($item['compare_price']) && $item['compare_price'])
                                                    <small class="text-muted text-decoration-line-through">${{ number_format($item['compare_price'], 2) }}</small>
                                                @endif
                                            </td>
                                            <td class="text-center">
                                                <form action="{{ route('cart.update', $id) }}" method="POST" class="update-form">
                                                    @csrf
                                                    @method('PATCH')
                                                    <div class="input-group input-group-sm mx-auto" style="max-width: 120px;">
                                                        <button class="btn btn-outline-secondary decrement" type="button" style="border-color: #D4AF37;">
                                                            <i class="bi bi-dash" style="color: #996515;"></i>
                                                        </button>
                                                        <input type="number" name="quantity" value="{{ $item['quantity'] }}" min="1" class="form-control text-center quantity-input" style="border-color: #D4AF37;">
                                                        <button class="btn btn-outline-secondary increment" type="button" style="border-color: #D4AF37;">
                                                            <i class="bi bi-plus" style="color: #996515;"></i>
                                                        </button>
                                                    </div>
                                                </form>
                                            </td>
                                            <td class="text-end fw-semibold" style="color: #996515;">
                                                ${{ number_format($item['price'] * $item['quantity'], 2) }}
                                            </td>
                                            <td class="text-end">
                                                <form action="{{ route('cart.remove', $id) }}" method="POST">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-dark" title="Remove" style="border-color: #D4AF37; color: #996515;">
                                                        <i class="bi bi-trash"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        @else
                            <div class="text-center py-5">
                                <i class="bi bi-cart-x display-4 text-muted mb-3" style="color: #D4AF37;"></i>
                                <h4 class="mb-2" style="color: #996515;">Your cart is empty</h4>
                                <p class="text-muted mb-4">Looks like you haven't added anything yet.</p>
                                <a href="{{ url('/allproducts') }}" class="btn px-4" style="background-color: #996515; color: white;">
                                    <i class="bi bi-arrow-left me-1"></i> Continue Shopping
                                </a>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
    
            <!-- Order Summary Section -->
            @if(count($cartItems) > 0)
            <div class="col-lg-4 mt-4 mt-lg-0">
                <div class="card shadow-sm border-0 sticky-top" style="top: 20px; border-color: #D4AF37 !important;">
                    <div class="card-body p-4">
                        <h5 class="fw-bold mb-3" style="color: #996515;">Order Summary</h5>
            
                        @php
                            $subtotal = 0;
                            foreach ($cartItems as $item) {
                                $subtotal += $item['price'] * $item['quantity'];
                            }
                        @endphp
            
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Subtotal</span>
                            <span style="color: #996515;">${{ number_format($subtotal, 2) }}</span>
                        </div>
            
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Shipping</span>
                            <span class="text-success">Free</span>
                        </div>
            
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Tax</span>
                            <span style="color: #996515;">$0.00</span>
                        </div>
            
                        <hr style="border-color: #D4AF37;">
            
                        <div class="d-flex justify-content-between mb-4">
                            <span class="fw-bold" style="color: #996515;">Total</span>
                            <span class="fw-bold fs-5" style="color: #996515;">
                                ${{ number_format($subtotal, 2) }}
                            </span>
                        </div>
            
                        <a href="{{ route('checkout') }}" class="btn w-100 py-2 mb-3" style="background-color: #996515; color: white;">
                            Proceed to Checkout
                        </a>
            
                        <div class="alert alert-info small mb-0" style="background-color: #F5E7C1; border-color: #D4AF37; color: #996515;">
                            <i class="bi bi-info-circle me-2"></i> Free delivery on orders above $1000.
                        </div>
                    </div>
                </div>
            </div>
            @endif
            
            <!-- Related Products -->
            @if(count($cartItems) > 0 && count($products) > 0)
            <div class="row mt-5">
                <div class="col-12">
                    <h5 class="fw-bold mb-3" style="color: #996515;">You Might Also Like</h5>
                    <div class="container">
                        <div class="row gy-4" data-aos="fade-up" data-aos-delay="200" id="productsContainer">
                            @foreach($products as $product)
                            <div class="col-lg-4 col-md-6 mb-4 product-item" data-name="{{ strtolower($product->name) }}">
                                <div class="card h-100 product-card border-0 shadow perfume-card" style="border-color: #D4AF37 !important;">
                                    <div class="position-relative overflow-hidden rounded-top" style="height: 300px; background: #F5E7C1;">
                                        <div class="image-container h-100 w-100">
                                            <a href="{{ route('product_details', $product->id) }}" class="d-block h-100 w-100">
                                                <img src="{{ asset($product->image) }}" 
                                                    class="img-fluid product-image" 
                                                    alt="{{ $product->name }}"
                                                    style="width: 100%; height: 100%; object-fit: contain;">
                                                
                                                @if($product->second_image)
                                                <img src="{{ asset($product->second_image) }}" 
                                                    class="img-fluid product-image hover-image" 
                                                    alt="{{ $product->name }} alternate view"
                                                    style="width: 100%; height: 100%; object-fit: contain;">
                                                @endif
                                            </a>
                                        </div>
                                        
                                        <div class="card-actions position-absolute top-0 end-0 p-2">
                                            <button class="btn btn-sm btn-light rounded-circle shadow-sm" style="background-color: #F5E7C1; border-color: #D4AF37;">
                                                <i class="bi bi-heart" style="color: #996515;"></i>
                                            </button>
                                        </div>
                                        
                                        @if($product->discount_percent)
                                        <div class="badge position-absolute top-0 start-0 m-2" style="background-color: #996515;">
                                            -{{ $product->discount_percent }}%
                                        </div>
                                        @endif
                                    </div>
                        
                                    <div class="card-body text-center">
                                        <h6 class="card-title mb-2">
                                            <a href="{{ route('product_details', $product->id) }}" class="text-decoration-none" style="color: #996515;">
                                                {{ Str::limit($product->name, 45) }}
                                            </a>
                                        </h6>
                        
                                        <div class="rating mb-2">
                                            <i class="bi bi-star-fill" style="color: #D4AF37;"></i>
                                            <i class="bi bi-star-fill" style="color: #D4AF37;"></i>
                                            <i class="bi bi-star-fill" style="color: #D4AF37;"></i>
                                            <i class="bi bi-star-fill" style="color: #D4AF37;"></i>
                                            <i class="bi bi-star-half" style="color: #D4AF37;"></i>
                                        </div>
                        
                                        <div class="price-container mb-2">
                                            <span class="fw-bold" style="color: #996515;">${{ number_format($product->price, 2) }}</span>
                                            @if($product->previous_price)
                                            <small class="text-muted text-decoration-line-through ms-1">${{ number_format($product->previous_price, 2) }}</small>
                                            @endif
                                        </div>
                        
                                        <a href="{{ route('product_details', $product->id) }}" class="btn btn-sm rounded-pill px-3" style="border-color: #D4AF37; color: #996515;">
                                            View Details
                                        </a>
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        
                            <div id="noProductsFound" class="col-12 text-center py-5" style="display: none;">
                                <i class="bi bi-search display-4 mb-3" style="color: #D4AF37;"></i>
                                <h4 style="color: #996515;">No fragrances found</h4>
                                <p class="text-muted">Try adjusting your search or browse our collection</p>
                                <a href="{{ url()->current() }}" class="btn mt-3" style="border-color: #D4AF37; color: #996515;">
                                    <i class="bi bi-arrow-counterclockwise"></i> Reset Search
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>

    <!-- Custom Styling -->
    <style>
        .product-row:hover {
            background-color: #F5E7C1;
            transition: background-color 0.3s ease;
        }
        .quantity-input {
            -moz-appearance: textfield;
        }
        .quantity-input::-webkit-outer-spin-button,
        .quantity-input::-webkit-inner-spin-button {
            -webkit-appearance: none;
            margin: 0;
        }
        .object-fit-cover {
            object-fit: cover;
        }
        .btn-outline-secondary:hover {
            background-color: #D4AF37;
            color: white;
        }
        .btn:hover {
            background-color: #D4AF37 !important;
            color: white !important;
        }
        .perfume-card:hover {
            transform: translateY(-5px);
            transition: transform 0.3s ease;
            box-shadow: 0 10px 20px rgba(212, 175, 55, 0.2) !important;
        }
    </style>
</main>
<footer class="text-dark pt-5" style="background-color: #fec630; font-family: 'Poppins', sans-serif;">
  <div class="container-fluid px-5">
    <div class="row gy-4">

      <!-- Legal Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Legal</h5>
        <ul class="list-unstyled">
          <li><a href="/privacy-policy" class="text-dark text-decoration-none d-block mb-3">Privacy Policy</a></li>
          <li><a href="/shipping-policy" class="text-dark text-decoration-none d-block mb-3">Shipping Policy</a></li>
          <li><a href="/returns-refunds" class="text-dark text-decoration-none d-block mb-3">Returns & Refunds</a></li>
          <li><a href="/terms-conditions" class="text-dark text-decoration-none d-block">Terms & Conditions</a></li>
        </ul>
      </div>

      <!-- Contact Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Contact</h5>
        <p class="mb-4"><i class="bi bi-geo-alt-fill me-2"></i>104 Dundas St E, Toronto, ON M5B 1C9, Canada</p>
        <p class="mb-4"><i class="bi bi-telephone-fill me-2 "></i>416-602-1090</p>
        <p class="mb-4 "><i class="bi bi-envelope-fill me-2 "></i><a href="mailto:mycaptainvape@gmail.com" class="text-dark text-decoration-none">MYCAPTAINVAPE@gmail.COM</a></p>
      </div>

      <!-- Map Column -->
      <div class="col-lg-4 col-md-12">
        <h5 class="fw-bold mb-3">Our Location</h5>
        <div class="ratio ratio-4x3 shadow rounded" style="border: 2px solid #fff;">
          <iframe 
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2886.430242838252!2d-79.3743124845027!3d43.656439079121344!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x882b34d4b6b4f9c7%3A0x1234567890abcdef!2s104%20Dundas%20St%20E%2C%20Toronto%2C%20ON%20M5B%201C9!5e0!3m2!1sen!2sca!4v1699999999999!5m2!1sen!2sca" 
            width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy">
          </iframe>
        </div>
      </div>

    </div>

    <!-- Bottom Bar -->
    <div class="text-center py-3 mt-4 border-top" style="border-color: rgba(0,0,0,0.15) !important;">
      <small>© 2025 Captain Vape. All Rights Reserved.</small>
    </div>
  </div>
</footer>
  
    <!-- Scroll Top Button -->
    <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

    <!-- Vendor JS Files -->
    <script src="{{ asset('frontend/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/vendor/php-email-form/validate.js') }}"></script>
    <script src="{{ asset('frontend/assets/vendor/aos/aos.js') }}"></script>
    <script src="{{ asset('frontend/assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/vendor/purecounter/purecounter_vanilla.js') }}"></script>
    <script src="{{ asset('frontend/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
    <script src="{{ asset('frontend/assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
    
    <!-- Main JS File -->
    <script src="{{ asset('frontend/assets/js/main.js') }}"></script>
    
    <!-- Quantity Control Script -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            document.querySelectorAll('.increment').forEach(btn => {
                btn.addEventListener('click', function() {
                    const input = this.closest('.input-group').querySelector('.quantity-input');
                    input.value = parseInt(input.value) + 1;
                    this.closest('.update-form').submit();
                });
            });
    
            document.querySelectorAll('.decrement').forEach(btn => {
                btn.addEventListener('click', function() {
                    const input = this.closest('.input-group').querySelector('.quantity-input');
                    if (parseInt(input.value) > 1) {
                        input.value = parseInt(input.value) - 1;
                        this.closest('.update-form').submit();
                    }
                });
            });
    
            document.querySelectorAll('.quantity-input').forEach(input => {
                input.addEventListener('change', function() {
                    if (this.value < 1) this.value = 1;
                    this.closest('.update-form').submit();
                });
            });
        });
    </script>
</body>
</html>