<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Captain Vape</title>
  <meta name="description" content="">
  <meta name="keywords" content="">
  <meta name="csrf-token" content="{{ csrf_token() }}">

  <!-- Favicons -->
  <link href="{{ asset('assets/images/logg.png') }}" rel="icon">
  <link href="assets/img/apple-touch-icon.png" rel="apple-touch-icon">

  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css" integrity="sha512-pVrmAqHnV5v4RszFqV0XQvQn7o3b1n6oGv8y2rYqYVf8z8+Y6v9h3UOZ9zW9nGZrJ3VJ9oS3/1N6jL1d6x9Ypg==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <link href="{{ asset('frontend/assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/aos/aos.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">
  
  <!-- Main CSS File -->
  <link href="{{ asset('frontend/assets/css/main.css') }}" rel="stylesheet">
</head>

<body class="index-page">
   
 @include('header')


<main class="main">
    <div class="container py-5">
        <div class="row">
            <!-- Left Column - Shipping Info and Order Review -->
            <div class="col-lg-8">
                <!-- Shipping Information Card -->
                <div class="card border-0 shadow mb-4">
                    <div class="card-header bg-gold text-white py-3" style="background: linear-gradient(135deg, #D4AF37 0%, #F9D423 100%);">
                        <h2 class="h4 mb-0"><i class="bi bi-truck me-2"></i> Shipping Information</h2>
                    </div>
                    <div class="card-body p-4">
                        <form id="checkoutForm" action="{{ route('checkout.process') }}" method="POST">
                            @csrf
                            <div class="row g-3">
                                <!-- Name Field -->
                                <div class="col-md-6">
                                 
                              

                                      @foreach($cartItems as $id => $item)
                                  
                                        <input type="hidden" value="{{ $item['name'] }}" name="product_name">
                                    <input type="hidden" name="quantity" value="{{ $item['quantity'] }}">

                                       
                                    @endforeach
                                    <div class="form-floating">
                                        <input type="text" class="form-control border-gold" id="name" name="name" 
                                               value="{{ old('name', Auth::user()->name ?? '') }}" 
                                               required minlength="2" maxlength="100">
                                        <label for="name" class="text-gold">Full Name</label>
                                    </div>
                                    @error('name')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                        
                                <!-- Email Field -->
                                <div class="col-md-6">
                                    <div class="form-floating">
                                        <input type="email" class="form-control border-gold" id="email" name="email" 
                                               value="{{ old('email', Auth::user()->email ?? '') }}" 
                                               required>
                                        <label for="email" class="text-gold">Email</label>
                                    </div>
                                    @error('email')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                        
                                <!-- Address Field -->
                                <div class="col-12">
                                    <div class="form-floating">
                                        <input type="text" class="form-control border-gold" id="address" name="address" 
                                               value="{{ old('address', Auth::user()->address ?? '') }}" 
                                               required minlength="5" maxlength="255">
                                        <label for="address" class="text-gold">Address</label>
                                    </div>
                                    @error('address')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                        
                                <!-- City Field -->
                                <div class="col-md-4">
                                    <div class="form-floating">
                                        <input type="text" class="form-control border-gold" id="city" name="city" 
                                               value="{{ old('city', Auth::user()->city ?? '') }}" 
                                               required minlength="2" maxlength="50">
                                        <label for="city" class="text-gold">City</label>
                                    </div>
                                    @error('city')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                        
                                <!-- State Field -->
                                <div class="col-md-4">
                                    <div class="form-floating">
                                        <input type="text" class="form-control border-gold" id="state" name="state" 
                                               value="{{ old('state', Auth::user()->state ?? '') }}" 
                                               required minlength="2" maxlength="50">
                                        <label for="state" class="text-gold">State</label>
                                    </div>
                                    @error('state')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                        
                                <!-- ZIP Code Field -->
                                <div class="col-md-4">
                                    <div class="form-floating">
                                        <input type="text" class="form-control border-gold" id="zip" name="zip" 
                                               value="{{ old('zip', Auth::user()->zip ?? '') }}" 
                                               required pattern="[0-9]{5,10}" 
                                               title="Please enter a valid ZIP code (5-10 digits)">
                                        <label for="zip" class="text-gold">ZIP Code</label>
                                    </div>
                                    @error('zip')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                </div>
                        
                                <!-- Phone Number Field -->
                                <div class="col-md-8">
                                    <div class="form-floating">
                                        <input type="tel" class="form-control border-gold" id="number" name="number" 
                                               value="{{ old('number', Auth::user()->phone ?? '') }}" 
                                               required pattern="[0-9]{10,15}" 
                                               title="Please enter a valid phone number (10-15 digits)">
                                        <label for="number" class="text-gold">Phone Number</label>
                                    </div>
                                    @error('number')
                                        <div class="text-danger small mt-1">{{ $message }}</div>
                                    @enderror
                                    
                                    <!-- Hidden Fields -->
                                    <input type="hidden" name="amount" value="{{ number_format($total, 2, '.', '') }}">
                                    <input type="hidden" name="payment_method" value="cod">
                                    
                                    @foreach($cartItems as $id => $item)
                                        <input type="hidden" name="cart_items[{{ $id }}][product_id]" value="{{ $id }}">
                                        <input type="hidden" name="cart_items[{{ $id }}][size]" value="{{ $item['size'] ?? '' }}">
                                        <input type="hidden" name="cart_items[{{ $id }}][name]" value="{{ $item['name'] }}">
                                        <input type="hidden" name="cart_items[{{ $id }}][quantity]" value="{{ $item['quantity'] }}">
                                        <input type="hidden" name="cart_items[{{ $id }}][price]" value="{{ $item['price'] }}">
                                    @endforeach
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
                
                <!-- Payment Method Card -->
                <div class="card border-0 shadow mb-4">
                    <div class="card-header bg-gold text-white py-3" style="background: linear-gradient(135deg, #D4AF37 0%, #F9D423 100%);">
                        <h2 class="h4 mb-0"><i class="bi bi-credit-card me-2"></i> Payment Method</h2>
                    </div>
                    <div class="card-body p-4">
                        <div class="form-check">
                            <input class="form-check-input" type="radio" name="payment_method_radio" 
                                   id="cod" value="cod" checked disabled>
                            <label class="form-check-label" for="cod">
                                <i class="bi bi-cash-coin me-2 text-gold"></i> <strong>Cash on Delivery (COD)</strong>
                            </label>
                        </div>
                        <div class="alert alert-gold mt-3 mb-0" style="background-color: rgba(212, 175, 55, 0.1); border-color: rgba(212, 175, 55, 0.3); color: #D4AF37;">
                            <i class="bi bi-info-circle me-2"></i> Pay with cash when your order is delivered.
                        </div>
                    </div>
                </div>
                
                <!-- Order Review Card -->
                <div class="card border-0 shadow">
                    <div class="card-header bg-gold text-white py-3" style="background: linear-gradient(135deg, #D4AF37 0%, #F9D423 100%);">
                        <h2 class="h4 mb-0"><i class="bi bi-cart-check me-2"></i> Order Review</h2>
                    </div>
                    <div class="card-body p-4">
                        <div class="table-responsive">
                            <table class="table">
                                <thead class="bg-light">
                                    <tr>
                                        <th class="text-gold">Product</th>
                                        <th class="text-end text-gold">Price</th>
                                        <th class="text-end text-gold">Qty</th>
                                        <th class="text-end text-gold">Size</th>
                                        <th class="text-end text-gold">Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($cartItems as $id => $item)
                                    <tr>
                                        <td>{{ $item['name'] }}</td>
                                        <td class="text-end">${{ number_format($item['price'], 2) }}</td>
                                        <td class="text-end">{{ $item['quantity'] }}</td>
                                        <td class="text-end">{{ $item['size'] ?? '-' }}</td>
                                        <td class="text-end fw-bold">${{ number_format($item['price'] * $item['quantity'], 2) }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Right Column - Order Summary -->
            <div class="col-lg-4">
                <div class="card border-0 shadow sticky-top" style="top: 20px;">
                    <div class="card-header bg-gold text-white py-3" style="background: linear-gradient(135deg, #D4AF37 0%, #F9D423 100%);">
                        <h2 class="h4 mb-0"><i class="bi bi-receipt me-2"></i> Order Summary</h2>
                    </div>
                    <div class="card-body p-4">
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Subtotal</span>
                            <span>${{ number_format($total, 2) }}</span>
                        </div>
                        <div class="d-flex justify-content-between mb-2">
                            <span class="text-muted">Shipping</span>
                            <span class="text-success">Free</span>
                        </div>
                        <div class="d-flex justify-content-between mb-3">
                            <span class="text-muted">Tax</span>
                            <span>$0.00</span>
                        </div>
                        <hr class="my-3">
                        <div class="d-flex justify-content-between mb-4">
                            <span class="fw-bold text-gold">Total</span>
                            <span class="fw-bold fs-5 text-gold">${{ number_format($total, 2) }}</span>
                        </div>
                        
                        <button type="submit" form="checkoutForm" class="btn btn-gold w-100 py-3 mb-3 fw-bold" style="background: linear-gradient(135deg, #D4AF37 0%, #F9D423 100%); border: none; color: #fff;">
                            <i class="bi bi-check-circle me-2"></i> Place Order (COD)
                        </button>
                        
                        <div class="alert alert-gold small mb-0" style="background-color: rgba(212, 175, 55, 0.1); border-color: rgba(212, 175, 55, 0.3); color: #D4AF37;">
                            <i class="bi bi-info-circle me-2"></i> You'll pay when you receive the order.
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
    /* Custom Golden Theme */
    .bg-gold {
        background-color: #D4AF37 !important;
    }
    
    .text-gold {
        color: #D4AF37 !important;
    }
    
    .border-gold {
        border-color: #D4AF37 !important;
    }
    
    .alert-gold {
        background-color: rgba(212, 175, 55, 0.1);
        border-color: rgba(212, 175, 55, 0.3);
        color: #D4AF37;
    }
    
    .btn-gold {
        background-color: #D4AF37;
        border-color: #D4AF37;
        color: white;
    }
    
    .btn-gold:hover {
        background-color: #B38D2D;
        border-color: #B38D2D;
        color: white;
    }
    
    .card-header {
        border-radius: 0 !important;
    }
    
    .form-control:focus {
        box-shadow: 0 0 0 0.2rem rgba(212, 175, 55, 0.25);
        border-color: #D4AF37;
    }
    
    .table th {
        background-color: rgba(212, 175, 55, 0.05);
    }
    
    /* Gradient effects for gold elements */
    .gradient-gold {
        background: linear-gradient(135deg, #D4AF37 0%, #F9D423 100%);
    }
</style>

  

<footer class="text-dark pt-5" style="background-color: #fec630; font-family: 'Poppins', sans-serif;">
  <div class="container-fluid px-5">
    <div class="row gy-4">

      <!-- Legal Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Legal</h5>
        <ul class="list-unstyled">
          <li><a href="/privacy-policy" class="text-dark text-decoration-none d-block mb-3">Privacy Policy</a></li>
          <li><a href="/shipping-policy" class="text-dark text-decoration-none d-block mb-3">Shipping Policy</a></li>
          <li><a href="/returns-refunds" class="text-dark text-decoration-none d-block mb-3">Returns & Refunds</a></li>
          <li><a href="/terms-conditions" class="text-dark text-decoration-none d-block">Terms & Conditions</a></li>
        </ul>
      </div>

      <!-- Contact Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Contact</h5>
        <p class="mb-4"><i class="bi bi-geo-alt-fill me-2"></i>104 Dundas St E, Toronto, ON M5B 1C9, Canada</p>
        <p class="mb-4"><i class="bi bi-telephone-fill me-2 "></i>416-602-1090</p>
        <p class="mb-4 "><i class="bi bi-envelope-fill me-2 "></i><a href="mailto:mycaptainvape@gmail.com" class="text-dark text-decoration-none">MYCAPTAINVAPE@gmail.COM</a></p>
      </div>

      <!-- Map Column -->
      <div class="col-lg-4 col-md-12">
        <h5 class="fw-bold mb-3">Our Location</h5>
        <div class="ratio ratio-4x3 shadow rounded" style="border: 2px solid #fff;">
          <iframe 
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2886.430242838252!2d-79.3743124845027!3d43.656439079121344!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x882b34d4b6b4f9c7%3A0x1234567890abcdef!2s104%20Dundas%20St%20E%2C%20Toronto%2C%20ON%20M5B%201C9!5e0!3m2!1sen!2sca!4v1699999999999!5m2!1sen!2sca" 
            width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy">
          </iframe>
        </div>
      </div>

    </div>

    <!-- Bottom Bar -->
    <div class="text-center py-3 mt-4 border-top" style="border-color: rgba(0,0,0,0.15) !important;">
      <small>© 2025 Captain Vape. All Rights Reserved.</small>
    </div>
  </div>
</footer>
  

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="{{ asset('frontend/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/php-email-form/validate.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/aos/aos.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/purecounter/purecounter_vanilla.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
  
  <!-- Main JS File -->
  <script src="{{ asset('frontend/assets/js/main.js') }}"></script>
</body>
</html>