
@if(session('success'))
    <script>
        alert("{{ session('success') }}");
    </script>
@endif

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Captain Vape</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="{{ asset('assets/images/logg.jpg') }}" rel="icon">


  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{ asset('frontend/assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <!--<link href="{{ asset('frontend/assets/vendor/aos/aos.css') }}" rel="stylesheet">-->
  <link href="{{ asset('frontend/assets/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">
  
  <!-- Main CSS File -->
  <link href="{{ asset('frontend/assets/css/main.css') }}" rel="stylesheet">
  

  <!-- =======================================================
  * Template Name: Presento
  * Template URL: https://bootstrapmade.com/presento-bootstrap-corporate-template/
  * Updated: Aug 07 2024 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="index-page">

  
  <!-- CSS for Larger Floating WhatsApp Button -->

<!-- Overlay -->




@include('header')


  <main class="main">

  <section id="hero-carousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="3000" style="padding-top: 0px; padding-bottom:0px">
  <div class="carousel-inner">

    <!-- Single Slide (Originally Slide 2) -->
    <div class="carousel-item active" data-bs-interval="3000">
      <div class="position-relative">
        <img src="{{ asset('assets/main2.jpg') }}" style="height:600px" class="d-block w-100" alt="Captain Vape Flavors">
      <div class="carousel-caption d-flex flex-column justify-content-center align-items-center" 
     style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;
            background: rgba(0, 0, 0, 0.35);">
  <h1 style="color: #d4af37; font-weight: 800; font-size: 3.2rem; text-shadow: 2px 2px 8px rgba(0,0,0,0.9);">
    Premium E-Liquids
  </h1>
  <p style="color: #fff; font-size: 1.3rem; max-width: 700px; text-shadow: 1px 1px 6px rgba(0,0,0,0.9);">
    Exquisite Flavors - Smooth Throat Hit - Premium Quality Ingredients
  </p>
  
</div>
      </div>
    </div>

  </div>
</section>

    


  
  
  
  <!-- Include Google Font -->
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;700&display=swap" rel="stylesheet">




<section id="portfolio" class="portfolio section" id="shop" style="background-color: #fff8f0;margin-top:0px;">
  <div class="container section-title text-center" data-aos="fade-up">
    <h2 style="color: #FEC630; font-weight: 800; font-family: 'Poppins', sans-serif;"> E-Liquids </h2>
    
    

  <div class="container" style="font-family: 'Poppins', sans-serif;">
    <div class="row gy-4" data-aos="fade-up" data-aos-delay="200" id="productsContainer">
      @foreach($products as $product)
      <div class="col-lg-3 col-md-6 mb-4 product-item" data-name="{{ strtolower($product->name) }}">
        <div class="card h-100 product-card border-0 shadow-lg perfume-card"
             style="transition: transform 0.4s ease, box-shadow 0.4s ease; border-radius: 20px; background: #ffffff;">
          
          <!-- Image Section -->
        <!-- Image Section -->
<div class="position-relative overflow-hidden rounded-top" 
     style="  display: flex; justify-content: center; align-items: center;">

  <a href="{{ route('product_details', $product->id) }}" 
     class="d-block h-100 w-100" style="position: relative;">

    <img src="{{ asset($product->image) }}" 
         alt="{{ $product->name }}" 
         style="max-height: 100%; max-width: 100%; object-fit: cover; display: block; margin: auto; transition: opacity 0.3s;">

    @if($product->second_image)
    <img src="{{ asset($product->second_image) }}" 
         alt="{{ $product->name }} alternate view" 
         style="max-height: 100%; max-width: 100%; object-fit: cover; display: block; margin: auto; position: absolute; top: 0; left: 0; right: 0; bottom: 0; opacity: 0; transition: opacity 0.3s;">
    @endif

  </a>

  <!-- Wishlist -->
  <div class="card-actions position-absolute top-0 end-0 p-2">
    <button class="btn btn-sm rounded-circle shadow-sm"
            style="background-color: #fff; border: 2px solid #bfa14a; color: #bfa14a;">
      <i class="bi bi-heart"></i>
    </button>
  </div>

  <!-- Discount Badge -->
  @if($product->previous_price && $product->price < $product->previous_price)
    @php
      $discount = (($product->previous_price - $product->price) / $product->previous_price) * 100;
    @endphp
    <div class="badge position-absolute top-0 start-0 m-2"
         style="font-size: 13px; padding: 5px 10px; background: linear-gradient(45deg, #bfa14a, #d4b35f); color: #fff; border-radius: 30px;">
      -{{ round($discount) }}%
    </div>
  @endif
</div>


          <!-- Product Info -->
          <div class="card-body text-center">
            <h6 class="card-title mb-2" style="font-size: 18px; font-weight: 700; color: #bfa14a;">
              <a href="{{ route('product_details', $product->id) }}" 
                 class="text-decoration-none"
                 style="color: #bfa14a;">
                {{ Str::limit($product->name, 45) }}
              </a>
            </h6>


            <!-- Price -->
            <div class="price-container mb-2" style="font-size: 16px;">
              @if($product->previous_price && $product->price < $product->previous_price)
                <span style="color: #bfa14a; font-weight: 700;">${{ number_format($product->price, 2) }}</span>
                <small class="text-muted text-decoration-line-through ms-1">
                  ${{ number_format($product->previous_price, 2) }}
                </small>
                <div class="mt-1">
                  <span class="badge" style="background-color: #bfa14a; color: #fff; font-size: 12px; padding: 4px 10px;">
                    {{ round($discount) }}% Off
                  </span>
                </div>
              @else
                <span style="color: #bfa14a; font-size: 1.1rem; font-weight: 700;">
                  ${{ number_format($product->price, 2) }}
                </span>
              @endif
            </div>
          </div>
        </div>
      </div>
      @endforeach
    </div>
    <!-- 🔥 View All Products Button -->
<div class="text-center mt-4">
  <a href="{{ url('/liquid') }}" class="btn btn-lg" 
     style="background-color: #FEC630; color: #fff; font-weight: 600; border-radius: 30px; padding: 10px 30px;">
    View All Products
  </a>
</div>
  </div>
</section>
<style>
/* 🔥 Default adjustments */
.product-card {
  padding: 10px !important;
  border-radius: 15px !important;
}

.product-card img {
  max-height: 250px !important;   /* chhoti image */
  object-fit: contain !important; /* image ko crop na kare */
}

.product-card .card-body {
  padding: 10px !important;       /* spacing kam */
}

.product-card .card-title {
  font-size: 16px !important;     /* title thoda chhota */
  margin-bottom: 5px !important;
}

.product-card .price-container {
  font-size: 14px !important;     /* price chhoti */
}

/* 🔥 Mobile view (576px se neeche) */
@media (max-width: 576px) {
  #productsContainer .col-lg-3 {
    width: 50% !important;        /* ek row me 2 products */
    flex: 0 0 50% !important;
    max-width: 50% !important;
  }

  .product-card img {
    max-height: 180px !important; /* mobile pe aur chhoti image */
  }

  .product-card .card-title {
    font-size: 13px !important;
    font-weight: 600 !important;
  }

  .product-card .price-container {
    font-size: 12px !important;
  }

  .product-card .badge {
    font-size: 10px !important;
    padding: 3px 6px !important;
  }

  .card-actions button {
    width: 26px !important;
    height: 26px !important;
    font-size: 12px !important;
  }
}

</style>

<style>
  /* Search Bar Styling */
  .search-container {
    position: relative;
    width: 100%;
  }
  
  .search-input {
    padding: 12px 20px;
    border-radius: 50px;
    border: 2px solid #333; /* Darker border */
    width: 100%;
    font-size: 1rem;
    transition: all 0.3s ease;
    padding-right: 50px;
    color: #333;
    font-weight: 500;
  }
  
  .search-input:focus {
    border-color: #d63384;
    box-shadow: 0 0 0 3px rgba(214, 51, 132, 0.2);
    outline: none;
  }
  .
  
  .search-btn {
    position: absolute;
    right: 5px;
    top: 50%;
    transform: translateY(-50%);
    background: transparent;
    border: none;
    color: #333;
    font-size: 1.2rem;
    padding: 8px 15px;
    cursor: pointer;
  }
  
  /* Product Card Styling */
  .product-card {
    transition: all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1);
    border-radius: 12px;
    overflow: hidden;
    border: 1px solid rgba(0,0,0,0.1);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
  }
  
  .product-card:hover {
    transform: translateY(-10px) scale(1.02);
    box-shadow: 0 15px 30px rgba(0,0,0,0.2) !important;
  }
  
  .image-container {
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
  }
  
  .product-image {
    transition: all 0.5s ease;
    position: absolute;
    width: 100%;
    height: 100%;
    object-fit: contain;
    padding: 20px;
  }
  
  .hover-image {
    opacity: 0;
  }
  
  .product-card:hover .product-image:not(.hover-image) {
    opacity: 0;
    transform: scale(0.95);
  }
  
  .product-card:hover .hover-image {
    opacity: 1;
    transform: scale(1);
  }
  
  /* If no second image, keep main image visible on hover */
  .product-card:not(:has(.hover-image)):hover .product-image {
    opacity: 1 !important;
    transform: scale(1.05) !important;
  }
  
  /* Darker text styles */
  .card-title, .card-title a {
    color: #000 !important;
    font-weight: 700;
  }
  
  .price-container .text-primary {
    color: #000 !important;
    font-weight: 700;
  }
  
  /* Larger card size */
  
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
  // Search functionality
  const searchInput = document.getElementById('productSearch');
  const productItems = document.querySelectorAll('.product-item');
  
  searchInput.addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    
    productItems.forEach(item => {
      const productName = item.dataset.name;
      if (productName.includes(searchTerm)) {
        item.style.display = 'block';
      } else {
        item.style.display = 'none';
      }
    });
  });
  
  // Initialize hover effects
  const productCards = document.querySelectorAll('.product-card');
  productCards.forEach(card => {
    const hasHoverImage = card.querySelector('.hover-image') !== null;
    
    if (!hasHoverImage) {
      const mainImage = card.querySelector('.product-image');
      card.addEventListener('mouseenter', () => {
        mainImage.style.transform = 'scale(1.05)';
      });
      card.addEventListener('mouseleave', () => {
        mainImage.style.transform = 'scale(1)';
      });
    }
  });
});
</script>
    

    

 






    
    

 


  </main>

  <footer class="text-dark pt-5" style="background-color: #fec630; font-family: 'Poppins', sans-serif;">
  <div class="container-fluid px-5">
    <div class="row gy-4">

      <!-- Legal Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Legal</h5>
        <ul class="list-unstyled">
          <li><a href="/privacy-policy" class="text-dark text-decoration-none d-block mb-3">Privacy Policy</a></li>
          <li><a href="/shipping-policy" class="text-dark text-decoration-none d-block mb-3">Shipping Policy</a></li>
          <li><a href="/returns-refunds" class="text-dark text-decoration-none d-block mb-3">Returns & Refunds</a></li>
          <li><a href="/terms-conditions" class="text-dark text-decoration-none d-block">Terms & Conditions</a></li>
        </ul>
      </div>

      <!-- Contact Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Contact</h5>
        <p class="mb-4"><i class="bi bi-geo-alt-fill me-2"></i>104 Dundas St E, Toronto, ON M5B 1C9, Canada</p>
        <p class="mb-4"><i class="bi bi-telephone-fill me-2 "></i>416-602-1090</p>
        <p class="mb-4 "><i class="bi bi-envelope-fill me-2 "></i><a href="mailto:mycaptainvape@gmail.com" class="text-dark text-decoration-none">MYCAPTAINVAPE@gmail.COM</a></p>
      </div>

      <!-- Map Column -->
      <div class="col-lg-4 col-md-12">
        <h5 class="fw-bold mb-3">Our Location</h5>
        <div class="ratio ratio-4x3 shadow rounded" style="border: 2px solid #fff;">
          <iframe 
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2886.430242838252!2d-79.3743124845027!3d43.656439079121344!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x882b34d4b6b4f9c7%3A0x1234567890abcdef!2s104%20Dundas%20St%20E%2C%20Toronto%2C%20ON%20M5B%201C9!5e0!3m2!1sen!2sca!4v1699999999999!5m2!1sen!2sca" 
            width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy">
          </iframe>
        </div>
      </div>

    </div>

    <!-- Bottom Bar -->
    <div class="text-center py-3 mt-4 border-top" style="border-color: rgba(0,0,0,0.15) !important;">
      <small>© 2025 Captain Vape. All Rights Reserved.</small>
    </div>
  </div>
</footer>

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="{{ asset('frontend/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/php-email-form/validate.js') }}"></script>
  <!--<script src="{{ asset('frontend/assets/vendor/aos/aos.js') }}"></script>-->
  <script src="{{ asset('frontend/assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/purecounter/purecounter_vanilla.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
  
  <!-- Main JS File -->
  <script src="{{ asset('frontend/assets/js/main.js') }}"></script>
  

</body>

</html>