
@if(session('success'))
    <script>
        alert("{{ session('success') }}");
    </script>
@endif

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Captain Vape</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="{{ asset('assets/images/logg.jpg') }}" rel="icon">


  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{ asset('frontend/assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <!--<link href="{{ asset('frontend/assets/vendor/aos/aos.css') }}" rel="stylesheet">-->
  <link href="{{ asset('frontend/assets/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css" integrity="sha512-dymI4/6L6H0DJ7j+JxFz9+9FJ+6j7iN/5Dqq6Yg5Dk7K+o2f6Zzht+oQqlqCqvP1KzO4v1s8l8U0i5xCjqU5w==" crossorigin="anonymous" referrerpolicy="no-referrer" />

  <!-- Main CSS File -->
  <link href="{{ asset('frontend/assets/css/main.css') }}" rel="stylesheet">
  

  <!-- =======================================================
  * Template Name: Presento
  * Template URL: https://bootstrapmade.com/presento-bootstrap-corporate-template/
  * Updated: Aug 07 2024 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="index-page">
  
  
  <!-- CSS for Larger Floating WhatsApp Button -->
  <style>
    .whatsapp-button {
      position: fixed;
      bottom: 110px; /* Adjust the distance from the bottom */
      right: 20px; /* Adjust the distance from the right */
      z-index: 1000; /* Ensure it stays on top of other elements */
      background-color: #25d366; /* WhatsApp green color */
      border-radius: 50%; /* Make it circular */
      padding: 15px; /* Increased padding for larger size */
      box-shadow: 0 4px 10px rgba(0, 0, 0, 0.2); /* Add a subtle shadow */
      transition: transform 0.3s ease, box-shadow 0.3s ease;
    }
  
    .whatsapp-button:hover {
      transform: scale(1.1); /* Slightly enlarge on hover */
      box-shadow: 0 6px 15px rgba(0, 0, 0, 0.3); /* Enhance shadow on hover */
    }
  
    .whatsapp-button img {
      display: block;
      width: 60px; /* Increased icon size */
      height: 60px; /* Increased icon size */
    }
  </style>
<!-- Overlay -->





<!-- Top Bar -->
<!-- Top Bar -->

<header class="header bg-white pb-0">
  <div class="topbar container d-flex justify-content-between align-items-center py-2 px-3">

    <!-- Left: Logo -->
    <a href="/" class="logo">
      <img src="{{ asset('assets/logo.png') }}" alt="Logo" class="img-fluid" style="height: 70px;">
    </a>

    <!-- Right Side: Search + Cart + Toggler -->






      <!-- Desktop Cart -->
      <div class="d-none d-md-flex align-items-center me-3">
         
           <a href="/" class="position-relative ms-3" style="color: black; text-decoration: none;">
                Welcome To Our Shop
              
            </a>
              <a href="/" class="position-relative ms-3" style="color: white; background:#D4AF37; border-radius:20px;padding:15px; text-decoration: none;">
                104 Dundas St E, Toronto, ON M5B 1C9
              
            </a>
      <a href="/cart" class="position-relative ms-3" style="color: black; text-decoration: none;">
                <i class="bi bi-cart3 fs-5"></i>
                <span class="badge bg-danger position-absolute top-0 start-100 translate-middle rounded-pill">
                    {{ $cartCount }}
                </span>
            </a>
      </div>

      <!-- Mobile Cart + Toggler -->
      <div class="d-md-none d-flex align-items-center">
       <a href="/cart" class="position-relative me-3" style="color: black; text-decoration: none;">
                <i class="bi bi-cart3 fs-5"></i>
                <span class="badge bg-danger position-absolute top-0 start-100 translate-middle rounded-pill">
                    {{ $cartCount }}
                </span>
            </a>
        <button class="navbar-toggler text-dark border-0 bg-transparent p-0" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse" aria-controls="navbarCollapse" aria-expanded="false" aria-label="Toggle navigation">
          <i class="bi bi-list fs-4"></i>
        </button>
      </div>
    </div>
  </div>

  <!-- Navigation -->
  <nav class="navbar navbar-expand-md">
    <div class="container-fluid px-0">
      <div class="collapse navbar-collapse" id="navbarCollapse">
        <ul class="navbar-nav w-100 justify-content-center flex-wrap py-2 m-0">
          <li class="nav-item"><a class="nav-link " href="/">Home</a></li>
       
          <li class="nav-item"><a class="nav-link" href="/disposibles">disposibles</a></li>
          <li class="nav-item"><a class="nav-link" href="/vapepods">Vape Pods</a></li>
          <li class="nav-item"><a class="nav-link" href="/heat">Heat-Not Burn</a></li>
          <li class="nav-item"><a class="nav-link" href="/liquid">E-Liquid</a></li>
          <li class="nav-item"><a class="nav-link" href="/hardware">Hardware</a></li>
          <li class="nav-item"><a class="nav-link" href="/clean">CLearance</a></li>
          <li class="nav-item"><a class="nav-link" href="/contactus">Contact</a></li>
        </ul>
      </div>
    </div>
  </nav>
</header>
<style>
@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');

.header {
  box-shadow: 0 2px 15px rgba(0, 0, 0, 0.08);
  z-index: 1030;
  font-family: 'Poppins', sans-serif;
  background: #fff;
}

.topbar {
  border-bottom: 1px solid #eee;
}

.nav-link {
  color: #222 !important;
  padding: 10px 15px !important;
  font-weight: 500;
  font-size: 15px;
  letter-spacing: 0.5px;
  position: relative;
  white-space: nowrap;
  transition: color 0.3s ease;
}

.nav-link:hover,
.nav-link.active {
  color: #d4af37 !important;
}

.nav-link::after {
  content: "";
  position: absolute;
  width: 0;
  height: 2px;
  background: #d4af37;
  left: 0;
  bottom: 0;
  transition: width 0.3s ease;
}

.nav-link:hover::after,
.nav-link.active::after {
  width: 100%;
}

.cart-icon .bi-cart3 {
  font-size: 1.4rem;
  color: #222;
}

/* Mobile Styles */
@media (max-width: 767.98px) {
  .topbar {
    flex-wrap: wrap;
    justify-content: flex-start !important;
  }

  .logo {
    order: 0 !important;
    margin-right: auto !important;
  }

  .flex-wrap-mobile {
    order: 1;
    flex: 1;
    justify-content: space-between !important;
  }

  .navbar-nav {
    background: #fff;
  }

  .nav-item {
    width: 100%;
    text-align: center;
  }

  .nav-link {
    padding: 12px 15px !important;
    border-top: 1px solid #eee;
  }

  .cart-icon {
    display: none !important;
  }

  #searchInput {
    width: 100% !important;
  }
}
</style>





  <main class="main">

  <section id="hero-carousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="3000" style="padding-top: 0px;">
  <div class="carousel-inner">

    <!-- Single Slide (Originally Slide 2) -->
    <div class="carousel-item active" data-bs-interval="3000">
      <div class="position-relative">
        <img src="{{ asset('assets/banner_2.png') }}" style="height:800px" class="d-block w-100" alt="Captain Vape Flavors">
      <div class="carousel-caption d-flex flex-column justify-content-center align-items-center" 
     style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;
            background: rgba(0, 0, 0, 0.35);">
  <h1 style="color: #d4af37; font-weight: 800; font-size: 3.2rem; text-shadow: 2px 2px 8px rgba(0,0,0,0.9);">
    Vape Hardware
  </h1>
  <p style="color: #fff; font-size: 1.3rem; max-width: 700px; text-shadow: 1px 1px 6px rgba(0,0,0,0.9);">
    Premium Devices - Cutting-Edge Technology - Unmatched Performance
  </p>
  <a href="/hardware" 
     class="btn btn-lg mt-3"
     style="background-color: #d4af37; color: #000; border: none; padding: 12px 35px; font-weight: 600; border-radius: 30px;">
    Shop Hardware
  </a>
</div>
      </div>
    </div>

  </div>
</section>

    


  
  
  
  <!-- Include Google Font -->
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;700&display=swap" rel="stylesheet">



<section id="portfolio" class="portfolio section" style="background-color: #fff8f0;">
  <div class="container section-title text-center" data-aos="fade-up">
    <h2 style="color: #bfa14a; font-weight: 800; font-family: 'Poppins', sans-serif;">✨ Vape HardWare ✨</h2>
    <p style="color: #7a6a2f; font-size: 1.1rem;">Indulge in our latest premium vape products, crafted for connoisseurs</p>
    
    <!-- Search Bar -->
    <div class="row justify-content-center mb-5">
      <div class="col-md-6">
        <div class="search-container mt-3">
          <input type="text" id="productSearch" class="form-control search-input" 
                 placeholder="🔍 Search products..."
                 style="border: 2px solid #bfa14a; border-radius: 50px; padding: 12px 20px;">
        </div>
      </div>
    </div>
  </div>

  <div class="container" style="font-family: 'Poppins', sans-serif;">
    <div class="row gy-4" data-aos="fade-up" data-aos-delay="200" id="productsContainer">
      @foreach($products as $product)
      <div class="col-lg-3 col-md-6 mb-4 product-item" data-name="{{ strtolower($product->name) }}">
        <div class="card h-100 product-card border-0 shadow-lg perfume-card"
             style="transition: transform 0.4s ease, box-shadow 0.4s ease; border-radius: 20px; background: #ffffff;">
          
          <!-- Image Section -->
          <div class="position-relative overflow-hidden rounded-top" style="height: 350px; background: #fff9f3;">
            <a href="{{ route('product_details', $product->id) }}" class="d-block h-100 w-100" style="position: relative;">
              <img src="{{ asset($product->image) }}" 
                   class="img-fluid product-image" 
                   alt="{{ $product->name }}"
                   style="width: 100%; height: 100%; object-fit: contain; transition: opacity 0.3s;">
              @if($product->second_image)
              <img src="{{ asset($product->second_image) }}" 
                   class="img-fluid product-image hover-image" 
                   alt="{{ $product->name }} alternate view"
                   style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; object-fit: contain; opacity: 0; transition: opacity 0.3s;">
              @endif
            </a>

            <!-- Wishlist -->
            <div class="card-actions position-absolute top-0 end-0 p-2">
              <button class="btn btn-sm rounded-circle shadow-sm"
                      style="background-color: #fff; border: 2px solid #bfa14a; color: #bfa14a;">
                <i class="bi bi-heart"></i>
              </button>
            </div>

            <!-- Discount Badge -->
            @if($product->previous_price && $product->price < $product->previous_price)
              @php
                $discount = (($product->previous_price - $product->price) / $product->previous_price) * 100;
              @endphp
              <div class="badge position-absolute top-0 start-0 m-2"
                   style="font-size: 13px; padding: 5px 10px; background: linear-gradient(45deg, #bfa14a, #d4b35f); color: #fff; border-radius: 30px;">
                -{{ round($discount) }}%
              </div>
            @endif
          </div>

          <!-- Product Info -->
          <div class="card-body text-center">
            <h6 class="card-title mb-2" style="font-size: 18px; font-weight: 700; color: #bfa14a;">
              <a href="{{ route('product_details', $product->id) }}" 
                 class="text-decoration-none"
                 style="color: #bfa14a;">
                {{ Str::limit($product->name, 45) }}
              </a>
            </h6>

            <!-- Rating -->
            <div class="rating mb-2" style="font-size: 16px; color: #bfa14a;">
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-fill"></i>
              <i class="bi bi-star-half"></i>
            </div>

            <!-- Price -->
            <div class="price-container mb-2" style="font-size: 16px;">
              @if($product->previous_price && $product->price < $product->previous_price)
                <span style="color: #bfa14a; font-weight: 700;">${{ number_format($product->price, 2) }}</span>
                <small class="text-muted text-decoration-line-through ms-1">
                  ${{ number_format($product->previous_price, 2) }}
                </small>
                <div class="mt-1">
                  <span class="badge" style="background-color: #bfa14a; color: #fff; font-size: 12px; padding: 4px 10px;">
                    {{ round($discount) }}% Off
                  </span>
                </div>
              @else
                <span style="color: #bfa14a; font-size: 1.1rem; font-weight: 700;">
                  ${{ number_format($product->price, 2) }}
                </span>
              @endif
            </div>
          </div>
        </div>
      </div>
      @endforeach
    </div>
  </div>
</section>

<style>
  .product-card:hover {
    transform: translateY(-8px) scale(1.02);
    box-shadow: 0 15px 40px rgba(191, 161, 74, 0.3) !important;
  }
  .product-card:hover .hover-image { opacity: 1 !important; }
  .product-card:hover .product-image:first-of-type { opacity: 0; }
</>

  
</section>

<style>
  /* Search Bar Styling */
  .search-container {
    position: relative;
    width: 100%;
  }
  
  .search-input {
    padding: 12px 20px;
    border-radius: 50px;
    border: 2px solid #333; /* Darker border */
    width: 100%;
    font-size: 1rem;
    transition: all 0.3s ease;
    padding-right: 50px;
    color: #333;
    font-weight: 500;
  }
  
  .search-input:focus {
    border-color: #d63384;
    box-shadow: 0 0 0 3px rgba(214, 51, 132, 0.2);
    outline: none;
  }
  .
  
  .search-btn {
    position: absolute;
    right: 5px;
    top: 50%;
    transform: translateY(-50%);
    background: transparent;
    border: none;
    color: #333;
    font-size: 1.2rem;
    padding: 8px 15px;
    cursor: pointer;
  }
  
  /* Product Card Styling */
  .product-card {
    transition: all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1);
    border-radius: 12px;
    overflow: hidden;
    border: 1px solid rgba(0,0,0,0.1);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
  }
  
  .product-card:hover {
    transform: translateY(-10px) scale(1.02);
    box-shadow: 0 15px 30px rgba(0,0,0,0.2) !important;
  }
  
  .image-container {
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
  }
  
  .product-image {
    transition: all 0.5s ease;
    position: absolute;
    width: 100%;
    height: 100%;
    object-fit: contain;
    padding: 20px;
  }
  
  .hover-image {
    opacity: 0;
  }
  
  .product-card:hover .product-image:not(.hover-image) {
    opacity: 0;
    transform: scale(0.95);
  }
  
  .product-card:hover .hover-image {
    opacity: 1;
    transform: scale(1);
  }
  
  /* If no second image, keep main image visible on hover */
  .product-card:not(:has(.hover-image)):hover .product-image {
    opacity: 1 !important;
    transform: scale(1.05) !important;
  }
  
  /* Darker text styles */
  .card-title, .card-title a {
    color: #000 !important;
    font-weight: 700;
  }
  
  .price-container .text-primary {
    color: #000 !important;
    font-weight: 700;
  }
  
  /* Larger card size */
  .perfume-card {
    min-height: 500px;
  }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
  // Search functionality
  const searchInput = document.getElementById('productSearch');
  const productItems = document.querySelectorAll('.product-item');
  
  searchInput.addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    
    productItems.forEach(item => {
      const productName = item.dataset.name;
      if (productName.includes(searchTerm)) {
        item.style.display = 'block';
      } else {
        item.style.display = 'none';
      }
    });
  });
  
  // Initialize hover effects
  const productCards = document.querySelectorAll('.product-card');
  productCards.forEach(card => {
    const hasHoverImage = card.querySelector('.hover-image') !== null;
    
    if (!hasHoverImage) {
      const mainImage = card.querySelector('.product-image');
      card.addEventListener('mouseenter', () => {
        mainImage.style.transform = 'scale(1.05)';
      });
      card.addEventListener('mouseleave', () => {
        mainImage.style.transform = 'scale(1)';
      });
    }
  });
});
</script>
    

    

 






    
    

 

<section id="contact" class="contact section" style="background-color: #fffaf0; padding: 80px 0; font-family: 'Poppins', sans-serif;">

  <!-- Section Title -->
  <div class="container section-title text-center" data-aos="fade-up">
    <h2 style="font-weight: 600; color: #b8860b; margin-bottom: 15px; font-size: 2.2rem;">Contact Us</h2>
    <p style="color: #8b7500; font-size: 1rem; max-width: 600px; margin: 0 auto;">Get in touch with our team for any inquiries or assistance</p>
  </div>

  <div class="container" data-aos="fade-up" data-aos-delay="100" style="margin-top: 50px;">

    <div class="row gy-4">
      <!-- Contact Info -->
      <div class="col-lg-6">
        <div class="row gy-4">

          <div class="col-lg-6">
            <div class="info-item p-4 text-center" style="background: white; border-radius: 10px; box-shadow: 0 4px 15px rgba(184,134,11,0.1); height: 100%; transition: all 0.3s ease;">
              <div class="icon-container mb-3" style="width: 50px; height: 50px; background: linear-gradient(45deg, #FFD700, #B8860B); border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; margin: 0 auto;">
                <i class="bi bi-geo-alt" style="color: white; font-size: 20px;"></i>
              </div>
              <h3 style="font-weight: 500; color: #b8860b; margin-bottom: 10px; font-size: 1.2rem;">Address</h3>
              <p style="color: #555; font-size: 0.95rem;">Brampton, ON</p>
            </div>
          </div>


          <div class="col-md-6">
            <div class="info-item p-4 text-center" style="background: white; border-radius: 10px; box-shadow: 0 4px 15px rgba(184,134,11,0.1); height: 100%; transition: all 0.3s ease;">
              <div class="icon-container mb-3" style="width: 50px; height: 50px; background: linear-gradient(45deg, #FFD700, #B8860B); border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; margin: 0 auto;">
                <i class="bi bi-envelope" style="color: white; font-size: 20px;"></i>
              </div>
              <h3 style="font-weight: 500; color: #b8860b; margin-bottom: 10px; font-size: 1.2rem;">Email Us</h3>
              <p style="color: #555; font-size: 0.95rem;">mycaptainvape@gmail.com</p>
            </div>
          </div>

        </div>
      </div>

      <!-- Contact Form -->
      <div class="col-lg-6">
        <form action="{{route('contact_form')}}" method="POST" class="p-4" style="background: white; border-radius: 10px; box-shadow: 0 4px 15px rgba(184,134,11,0.1);" data-aos="fade-up" data-aos-delay="500">
          @csrf
          <div class="row gy-3">

            <div class="col-md-6">
              <input type="text" name="name" class="form-control p-3" placeholder="Your Name" required style="border: 1px solid #e0d6b4; border-radius: 6px; font-size: 0.95rem;">
            </div>

            <div class="col-md-6">
              <input type="email" name="email" class="form-control p-3" placeholder="Your Email" required style="border: 1px solid #e0d6b4; border-radius: 6px; font-size: 0.95rem;">
            </div>

            <div class="col-md-12">
              <input type="text" name="subject" class="form-control p-3" placeholder="Subject" required style="border: 1px solid #e0d6b4; border-radius: 6px; font-size: 0.95rem;">
            </div>

            <div class="col-md-12">
              <textarea name="message" rows="5" class="form-control p-3" placeholder="Your Message" required style="border: 1px solid #e0d6b4; border-radius: 6px; font-size: 0.95rem;"></textarea>
            </div>

            <div class="col-md-12 text-center mt-3">
              <button class="btn py-2 px-4" style="background: linear-gradient(45deg, #FFD700, #B8860B); color: white; border: none; border-radius: 6px; font-weight: 500; font-size: 0.95rem; transition: all 0.3s;">Send Message</button>
            </div>

          </div>
        </form>
      </div>

    </div>
  </div>

  <style>
    .form-control:focus {
      border-color: #FFD700 !important;
      box-shadow: 0 0 0 0.2rem rgba(255, 215, 0, 0.25) !important;
    }
    .btn:hover {
      background: linear-gradient(45deg, #B8860B, #FFD700) !important;
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(184, 134, 11, 0.3);
    }
    .info-item:hover {
      transform: translateY(-5px);
      box-shadow: 0 6px 20px rgba(184,134,11,0.2) !important;
    }
  </style>

</section>



  </main>  
<footer id="footer" class="footer py-5" style="background-color: #121212; color: #fff8e1;">
  <div class="container footer-top">
    <div class="row gy-4">

      <!-- Column 1: About -->
      <div class="col-lg-3 col-md-6 footer-about">
        <a href="/" class="logo d-flex align-items-center mb-3">
          <span class="sitename" style="font-size: 26px; font-weight: 700; color: #ffd700; font-family: 'Playfair Display', serif;">Captain Vape</span>
        </a>
        <p style="color: #e6c675; line-height: 1.6;">
          Your premium destination for exclusive vape products, flavors, and accessories. Elevate your vaping experience with Captain Vape.
        </p>
        <div class="footer-contact pt-3">
          <p style="color: #e6c675;"><i class="bi bi-geo-alt-fill me-2" style="color: #ffd700;"></i> toronto , Canada</p>
         
        </div>
      </div>

      <!-- Column 2: Explore Links -->
      <div class="col-lg-3 col-md-6 footer-links">
        <h4 style="font-size: 18px; font-weight: 600; color: #ffd700; margin-bottom: 20px; position: relative; padding-bottom: 10px; font-family: 'Playfair Display', serif;">
          <span style="position: absolute; bottom: 0; left: 0; width: 50px; height: 2px; background: #e6c675;"></span>
          Explore
        </h4>
       <ul style="list-style: none; padding: 0;">
  <li class="mb-2"><a href="/" style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">Home</a></li>


  <li class="mb-2"><a href="/contactus" style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">Contact Us</a></li>

  <li class="mb-2"><a href="/clean" style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">Clean</a></li>
  <li class="mb-2"><a href="/vapepods" style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">Vape Pods</a></li>
  <li class="mb-2"><a href="/hardware" style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">Hardware</a></li>
  <li class="mb-2"><a href="/disposibles" style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">Disposables</a></li>
  <li class="mb-2"><a href="/liquid" style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">E-Liquid</a></li>
  <li class="mb-2"><a href="/heat" style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">Heat</a></li>
</ul>

      </div>

      <!-- Column 3: Policy Links -->
      <div class="col-lg-3 col-md-6">
        <h4 style="font-size: 18px; font-weight: 600; color: #ffd700; margin-bottom: 20px; position: relative; padding-bottom: 10px; font-family: 'Playfair Display', serif;">
          <span style="position: absolute; bottom: 0; left: 0; width: 50px; height: 2px; background: #e6c675;"></span>
          Our Policies
        </h4>
        <ul style="list-style: none; padding: 0;">
          <li class="mb-2"><a  style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">Privacy Policy</a></li>
          <li class="mb-2"><a style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">Terms of Service</a></li>
          <li class="mb-2"><a  style="color: #e6c675;" onmouseover="this.style.color='#ffd700'" onmouseout="this.style.color='#e6c675'">Refund Policy</a></li>
        </ul>
      </div>

      <!-- Column 4: Newsletter & Payment Methods -->
      <div class="col-lg-3 col-md-6 footer-newsletter">
        <p style="color: #e6c675; line-height: 1.6;">Subscribe to our newsletter for exclusive offers, new arrivals, and vaping tips.</p>

        <div class="container py-4">
          <h5 style="font-size: 16px; font-weight: 600; color: #ffd700; margin-bottom: 15px; font-family: 'Playfair Display', serif;">We Accept</h5>
          <div class="d-flex flex-wrap align-items-center gap-3">
            <img src="{{ asset('assets/images/visa.jpg') }}" alt="Visa" style="height: 30px;">
            <img src="{{ asset('assets/images/master.png') }}" alt="MasterCard" style="height: 30px;">
            <img src="{{ asset('assets/images/amex.png') }}" alt="Amex" style="height: 30px;">
            <img src="{{ asset('assets/images/diners.jpg') }}" alt="Diners Club" style="height: 30px;">
            <img src="{{ asset('assets/images/paypal.png') }}" alt="PayPal" style="height: 30px;">
          </div>
        </div>
      </div>
    </div>
  </div>

  <div class="container copyright text-center mt-4 pt-4" style="border-top: 1px solid #3a3a3a;">
    <p style="color: #e6c675; margin-bottom: 5px;">© <span style="color: #ffd700; font-weight: 600;">Captain Vape</span> | All Rights Reserved</p>
    <div class="credits" style="color: #e6c675; font-size: 14px;">
      Designed by <a href="https://bizzsofts.com/" style="color: #ffd700; text-decoration: none;">Bizzsofts Development</a>
    </div>
  </div>
</footer>



<style>
@import url('https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;600;700&display=swap');

.footer {
    background: linear-gradient(to bottom, #1a1a1a 0%, #000000 100%);
}

.footer a:hover {
    color: #d1a570 !important;
}

.social-links a {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    width: 36px;
    height: 36px;
    background: rgba(255,255,255,0.1);
    border-radius: 50%;
    transition: all 0.3s;
}

.social-links a:hover {
    background: #d1a570;
    transform: translateY(-3px);
}

.form-control:focus {
    box-shadow: 0 0 0 0.25rem rgba(209, 165, 112, 0.25);
    border-color: #d1a570;
}

.btn-primary:hover {
    background: #c09562 !important;
    border-color: #c09562 !important;
}
</style>
   
  

  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="{{ asset('frontend/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/php-email-form/validate.js') }}"></script>
  <!--<script src="{{ asset('frontend/assets/vendor/aos/aos.js') }}"></script>-->
  <script src="{{ asset('frontend/assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/purecounter/purecounter_vanilla.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
  
  <!-- Main JS File -->
  <script src="{{ asset('frontend/assets/js/main.js') }}"></script>
  

</body>

</html>