<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Order Status</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap CSS -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

  <!-- Bootstrap Icons -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">

  <style>
    body {
      background: linear-gradient(135deg, #f0f4f8, #fff);
      font-family: 'Segoe UI', sans-serif;
    }

    .status-card {
      border: none;
      border-radius: 2rem;
      overflow: hidden;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.08);
      background: #ffffff;
    }

    .icon-success {
      font-size: 4rem;
      color: #28a745;
    }

    .icon-warning {
      font-size: 4rem;
      color: #ffc107;
    }

    .badge-status {
      font-size: 0.9rem;
      padding: 0.5em 1em;
      border-radius: 1em;
      text-transform: uppercase;
    }

    .btn-continue {
      border-radius: 2em;
      padding: 10px 30px;
      font-weight: 600;
    }
  </style>
</head>
<body>

  <div class="container py-5">
    <div class="row justify-content-center">
      <div class="col-md-8 col-lg-7">
        <div class="card status-card text-center p-4">

          @if($order->status === 'completed')
            <div class="mb-3">
              <i class="bi bi-check-circle-fill icon-success"></i>
            </div>
            <h2 class="fw-bold text-success">Thank You for Your Purchase!</h2>
            <p class="lead mb-2">Your order <strong>#{{ $order->id }}</strong> has been successfully placed.</p>
            <span class="badge bg-success badge-status mb-3">Order Completed</span>
            <p class="text-success fw-semibold mt-3">
              📸 Please take a screenshot of this page for your records.
            </p>

          @else
            <div class="mb-3">
              <i class="bi bi-exclamation-triangle-fill icon-warning"></i>
            </div>
            <h2 class="fw-bold text-warning">Payment Processing</h2>
            <p class="lead">We're verifying your payment for order <strong>#{{ $order->id }}</strong>.</p>
            <span class="badge bg-warning text-dark badge-status mb-3">Pending</span>
            <div class="spinner-border text-primary my-3" role="status">
              <span class="visually-hidden">Loading...</span>
            </div>
            <p class="text-muted">Please wait while we confirm your payment. This page will refresh automatically.</p>

            <script>
              setTimeout(() => window.location.reload(), 3000);
            </script>
          @endif

          <a href="{{ route('allproducts') }}" class="btn btn-outline-primary btn-continue mt-4">
            <i class="bi bi-arrow-left-circle me-2"></i>Continue Shopping
          </a>

        </div>
      </div>
    </div>
  </div>

  <!-- Bootstrap JS -->
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
