
@if(session('success'))
    <script>
        alert("{{ session('success') }}");
    </script>
@endif

<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">
  <title>Captain Vape</title>
  <meta name="description" content="">
  <meta name="keywords" content="">

  <!-- Favicons -->
  <link href="{{ asset('assets/images/logg.jpg') }}" rel="icon">


  <!-- Fonts -->
  <link href="https://fonts.googleapis.com" rel="preconnect">
  <link href="https://fonts.gstatic.com" rel="preconnect" crossorigin>
  <link href="https://fonts.googleapis.com/css2?family=Roboto:ital,wght@0,100;0,300;0,400;0,500;0,700;0,900;1,100;1,300;1,400;1,500;1,700;1,900&family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Raleway:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

  <!-- Vendor CSS Files -->
  <link href="{{ asset('frontend/assets/vendor/bootstrap/css/bootstrap.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/bootstrap-icons/bootstrap-icons.css') }}" rel="stylesheet">
  <!--<link href="{{ asset('frontend/assets/vendor/aos/aos.css') }}" rel="stylesheet">-->
  <link href="{{ asset('frontend/assets/vendor/glightbox/css/glightbox.min.css') }}" rel="stylesheet">
  <link href="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.css') }}" rel="stylesheet">
  
  <!-- Main CSS File -->
  <link href="{{ asset('frontend/assets/css/main.css') }}" rel="stylesheet">
  

  <!-- =======================================================
  * Template Name: Presento
  * Template URL: https://bootstrapmade.com/presento-bootstrap-corporate-template/
  * Updated: Aug 07 2024 with Bootstrap v5.3.3
  * Author: BootstrapMade.com
  * License: https://bootstrapmade.com/license/
  ======================================================== -->
</head>

<body class="index-page">
 
  
  <!-- CSS for Larger Floating WhatsApp Button -->
 
<!-- Overlay -->


<!-- Age Verification Modal -->
<div class="modal fade" id="ageVerificationModal" tabindex="-1" aria-labelledby="ageVerificationLabel" aria-hidden="true" data-bs-backdrop="static" data-bs-keyboard="false">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="background-color: #FEC630; border-radius: 10px; border: none;">
      <div class="modal-body text-center">
        
        <!-- Logo -->
        <img src="{{ asset('assets/logo.png') }}" alt="Captain Vape" style="height: 80px; margin-bottom: 20px;">
        
        <!-- Question -->
        <h5 style="color: #000; font-weight: 700; margin-bottom: 15px; text-decoration:underline">
          Are you 19 years or older?
        </h5>
        
        <!-- Paragraph -->
        <p style="color: #000; font-size: 14px; margin-bottom: 25px;">
          By entering this site, you certify that you are of legal smoking age in your province/state.
        </p>
        
        <!-- Buttons -->
        <div class="d-flex justify-content-center gap-3">
          <button id="confirmAge" 
                  class="btn px-4 py-2" 
                  style="background-color: #fff; color: #000; font-weight: 600; border: none; min-width: 120px; border-radius: 6px;">
            Yes, I'm 19+
          </button>
          <button id="denyAge" 
                  class="btn px-4 py-2" 
                  style="background-color: #333; color: #fff; font-weight: 600; border: none; min-width: 120px; border-radius: 6px;">
            No, I'm Underage
          </button>
        </div>
      </div>
    </div>
  </div>
</div>

<!-- Underage Warning Modal -->
<div class="modal fade" id="underageModal" tabindex="-1" aria-labelledby="underageModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content" style="border-radius: 10px; border: 2px solid #dc3545;">
      <div class="modal-header border-0">
        <h5 class="modal-title" id="underageModalLabel" style="color: #dc3545; font-weight: 700;">Access Denied</h5>
      </div>
      <div class="modal-body text-center">
        <i class="bi bi-exclamation-triangle-fill text-danger" style="font-size: 3rem;"></i>
        <h4 class="mt-3" style="color: #333;">You must be 19+ to enter</h4>
        <p class="mt-3" style="color: #666;">
          Our products are intended for adults of legal smoking age only.
        </p>
      </div>
      <div class="modal-footer border-0 justify-content-center">
        <button type="button" class="btn btn-secondary" onclick="redirectToExit()">Exit Site</button>
      </div>
    </div>
  </div>
</div>

<script>
// Show age verification modal on page load
document.addEventListener('DOMContentLoaded', function() {
  if(localStorage.getItem('ageVerified') !== 'true') {
    var ageModal = new bootstrap.Modal(document.getElementById('ageVerificationModal'));
    ageModal.show();
  }

  // Handle age confirmation
  document.getElementById('confirmAge').addEventListener('click', function() {
    localStorage.setItem('ageVerified', 'true');
    var ageModal = bootstrap.Modal.getInstance(document.getElementById('ageVerificationModal'));
    ageModal.hide();
  });

  // Handle underage response
  document.getElementById('denyAge').addEventListener('click', function() {
    var ageModal = bootstrap.Modal.getInstance(document.getElementById('ageVerificationModal'));
    ageModal.hide();

    var underageModal = new bootstrap.Modal(document.getElementById('underageModal'));
    underageModal.show();
  });
});

function redirectToExit() {
  window.location.href = 'https://www.google.com';
}

// Optional: reset after 24h
setTimeout(function() {
  localStorage.removeItem('ageVerified');
}, 24 * 60 * 60 * 1000);
</script>

<style>
.modal-backdrop.show {
  opacity: 0.9;
  background-color: #000;
}
body.modal-open {
  overflow: hidden;
}
</style>

<!-- Top Bar -->
<!-- Top Bar -->


@include('header')


<style>
@import url('https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap');

.header {
  box-shadow: 0 2px 15px rgba(0, 0, 0, 0.08);
  z-index: 1030;
  font-family: 'Poppins', sans-serif;
  background: #fff;
}

.topbar {
  border-bottom: 1px solid #eee;
}

.nav-link {
  color: #222 !important;
  padding: 10px 15px !important;
  font-weight: 500;
  font-size: 15px;
  letter-spacing: 0.5px;
  position: relative;
  white-space: nowrap;
  transition: color 0.3s ease;
}

.nav-link:hover,
.nav-link.active {
  color: #d4af37 !important;
}

.nav-link::after {
  content: "";
  position: absolute;
  width: 0;
  height: 2px;
  background: #d4af37;
  left: 0;
  bottom: 0;
  transition: width 0.3s ease;
}

.nav-link:hover::after,
.nav-link.active::after {
  width: 100%;
}

.cart-icon .bi-cart3 {
  font-size: 1.4rem;
  color: #222;
}

/* Mobile Styles */
@media (max-width: 767.98px) {
  .topbar {
    flex-wrap: wrap;
    justify-content: flex-start !important;
  }

  .logo {
    order: 0 !important;
    margin-right: auto !important;
  }

  .flex-wrap-mobile {
    order: 1;
    flex: 1;
    justify-content: space-between !important;
  }

  .navbar-nav {
    background: #fff;
  }

  .nav-item {
    width: 100%;
    text-align: center;
  }

  .nav-link {
    padding: 12px 15px !important;
    border-top: 1px solid #eee;
  }

  .cart-icon {
    display: none !important;
  }

  #searchInput {
    width: 100% !important;
  }
}
</style>


  <main class="main">

   
<section id="hero-carousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="3000" style="padding-top: 0px; padding-bottom:0px">
  <div class="carousel-inner">

    <!-- Slide 1 -->
    <div class="carousel-item active" data-bs-interval="3000">
      <div class="position-relative">
        <img src="{{ asset('assets/main.jpg') }}" style="height:400px; object-fit:cover;" class="d-block w-100" alt="Captain Vape Premium Collection">

        <!-- Text Overlay -->
        <div class="carousel-caption d-flex flex-column justify-content-center align-items-center" 
             style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;
                    background: rgba(0, 0, 0, 0.35);">
          <h1 style="color: #d4af37; font-weight: 800; font-size: 3.2rem; text-shadow: 2px 2px 8px rgba(0,0,0,0.9);">
            Captain Vape
          </h1>
          <p style="color: #fff; font-size: 1.3rem; max-width: 700px; text-shadow: 1px 1px 6px rgba(0,0,0,0.9);">
            Premium Disposable Vapes & Flavors – Experience the Taste of Luxury
          </p>
          <a href="/disposibles" 
             class="btn btn-lg mt-3"
             style="background-color: #d4af37; color: #000; border: none; padding: 12px 35px; font-weight: 600; border-radius: 30px;">
            Shop Now
          </a>
        </div>
      </div>
    </div>

    <!-- Slide 2 -->
    <div class="carousel-item" data-bs-interval="3000">
      <div class="position-relative">
        <img src="{{ asset('assets/main2.jpg') }}" style="height:400px; object-fit:cover;" class="d-block w-100" alt="Captain Vape Premium Pods">

        <!-- Text Overlay -->
        <div class="carousel-caption d-flex flex-column justify-content-center align-items-center" 
             style="position: absolute; top: 0; left: 0; width: 100%; height: 100%;
                    background: rgba(0, 0, 0, 0.35);">
          <h1 style="color: #d4af37; font-weight: 800; font-size: 3.2rem; text-shadow: 2px 2px 8px rgba(0,0,0,0.9);">
            Discover Vape Pods
          </h1>
          <p style="color: #fff; font-size: 1.3rem; max-width: 700px; text-shadow: 1px 1px 6px rgba(0,0,0,0.9);">
            Smooth Nicotine Delivery & Premium Vape Hardware
          </p>
          <a href="/vapepods" 
             class="btn btn-lg mt-3"
             style="background-color: #d4af37; color: #000; border: none; padding: 12px 35px; font-weight: 600; border-radius: 30px;">
            Explore Pods
          </a>
        </div>
      </div>
    </div>

  </div>

  <!-- Controls -->
  <button class="carousel-control-prev" type="button" data-bs-target="#hero-carousel" data-bs-slide="prev">
    <span class="carousel-control-prev-icon"></span>
  </button>
  <button class="carousel-control-next" type="button" data-bs-target="#hero-carousel" data-bs-slide="next">
    <span class="carousel-control-next-icon"></span>
  </button>

  <!-- Indicators -->
  <div class="carousel-indicators">
    <button type="button" data-bs-target="#hero-carousel" data-bs-slide-to="0" class="active"></button>
    <button type="button" data-bs-target="#hero-carousel" data-bs-slide-to="1"></button>
  </div>
</section>



    
    
 {{-- <section id="shop-categories" class="shop-categories section py-5 bg-light">
  <div class="container">
    <div class="row g-4">

      <!-- Disposables -->
      <div class="col-md-4">
        <a href="/disposibles" class="category-card d-block position-relative overflow-hidden rounded-3">
          <img src="{{asset('assets/dis.webp')}}" alt="Disposables" class="img-fluid w-100 h-100 object-fit-cover">
          <div class="category-overlay position-absolute w-100 h-100"></div>
          <div class="category-content position-absolute text-center w-100">
            <h3 class="category-title text-white mb-2">Disposables</h3>
            <span class="category-link text-uppercase text-white fw-light letter-spacing-2">Quick & Convenient</span>
          </div>
        </a>
      </div>
  
      <!-- Vape Pods -->
      <div class="col-md-4">
        <a href="/vapepods" class="category-card d-block position-relative overflow-hidden rounded-3">
          <img src="{{asset('assets/vape.jpg')}}" alt="Vape Pods" class="img-fluid w-100 h-100 object-fit-cover">
          <div class="category-overlay position-absolute w-100 h-100"></div>
          <div class="category-content position-absolute text-center w-100">
            <h3 class="category-title text-white mb-2">Vape Pods</h3>
            <span class="category-link text-uppercase text-white fw-light letter-spacing-2">Refillable & Stylish</span>
          </div>
        </a>
      </div>
  
      <!-- Hardware -->
      <div class="col-md-4">
        <a href="/hardware" class="category-card d-block position-relative overflow-hidden rounded-3">
          <img src="{{asset('assets/hard.avif')}}" alt="Hardware" class="img-fluid w-100 h-100 object-fit-cover">
          <div class="category-overlay position-absolute w-100 h-100"></div>
          <div class="category-content position-absolute text-center w-100">
            <h3 class="category-title text-white mb-2">Hardware</h3>
            <span class="category-link text-uppercase text-white fw-light letter-spacing-2">Premium Devices</span>
          </div>
        </a>
      </div>

    </div>
  </div>
</section> --}}

  
  <style>
    /* Modern Luxury Styling */
    .shop-categories {
      font-family: 'Playfair Display', serif;
    }
    
    .category-card {
      height: 500px;
      transition: all 0.5s cubic-bezier(0.23, 1, 0.32, 1);
      overflow: hidden;
      box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
    }
    
    .category-card:hover {
      transform: translateY(-8px);
      box-shadow: 0 25px 40px rgba(0, 0, 0, 0.15);
    }
    
    .category-overlay {
      background: linear-gradient(to top, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0.3) 50%, rgba(0,0,0,0) 100%);
      opacity: 0.8;
      transition: all 0.5s ease;
    }
    
    .category-card:hover .category-overlay {
      opacity: 0.9;
      background: linear-gradient(to top, rgba(0,0,0,0.9) 0%, rgba(0,0,0,0.4) 50%, rgba(0,0,0,0.1) 100%);
    }
    
    .category-content {
      bottom: 40px;
      left: 0;
      padding: 0 20px;
      transform: translateY(20px);
      transition: all 0.5s ease;
    }
    
    .category-card:hover .category-content {
      transform: translateY(0);
    }
    
    .category-title {
      font-size: 2rem;
      font-weight: 700;
      letter-spacing: 1px;
      text-shadow: 1px 1px 3px rgba(0,0,0,0.3);
      transition: all 0.3s ease;
    }
    
    .category-link {
      font-size: 0.9rem;
      letter-spacing: 3px;
      display: inline-block;
      padding-bottom: 2px;
      border-bottom: 1px solid rgba(255,255,255,0.3);
      transition: all 0.3s ease;
    }
    
    .category-card:hover .category-link {
      border-bottom-color: rgba(255,255,255,0.8);
      transform: translateY(5px);
    }
    
    .letter-spacing-2 {
      letter-spacing: 2px;
    }
    
    @media (max-width: 768px) {
      .category-card {
        height: 350px;
      }
      
      .category-title {
        font-size: 1.5rem;
      }
    }
  </style>
  
  <!-- Include Google Font -->
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;500;700&display=swap" rel="stylesheet">



<section id="portfolio" class="portfolio section" id="shop" style="background-color: #fff8f0;margin-top:0px;">
  <div class="container section-title text-center" data-aos="fade-up">
    <h2 style="color: #FEC630; font-weight: 800; font-family: 'Poppins', sans-serif;">Featured Vape And E-Liquids </h2>
    
    

  <div class="container" style="font-family: 'Poppins', sans-serif;">
    <div class="row gy-4" data-aos="fade-up" data-aos-delay="200" id="productsContainer">
      @foreach($liquid as $product)
      <div class="col-lg-3 col-md-6 mb-4 product-item" data-name="{{ strtolower($product->name) }}">
        <div class="card h-100 product-card border-0 shadow-lg perfume-card"
             style="transition: transform 0.4s ease, box-shadow 0.4s ease; border-radius: 20px; background: #ffffff;">
          
          <!-- Image Section -->
        <!-- Image Section -->
<div class="position-relative overflow-hidden rounded-top" 
     style="  display: flex; justify-content: center; align-items: center;">

  <a href="{{ route('product_details', $product->id) }}" 
     class="d-block h-100 w-100" style="position: relative;">

    <img src="{{ asset($product->image) }}" 
         alt="{{ $product->name }}" 
         style="max-height: 100%; max-width: 100%; object-fit: cover; display: block; margin: auto; transition: opacity 0.3s;">

    @if($product->second_image)
    <img src="{{ asset($product->second_image) }}" 
         alt="{{ $product->name }} alternate view" 
         style="max-height: 100%; max-width: 100%; object-fit: cover; display: block; margin: auto; position: absolute; top: 0; left: 0; right: 0; bottom: 0; opacity: 0; transition: opacity 0.3s;">
    @endif

  </a>

  <!-- Wishlist -->
  <div class="card-actions position-absolute top-0 end-0 p-2">
    <button class="btn btn-sm rounded-circle shadow-sm"
            style="background-color: #fff; border: 2px solid #bfa14a; color: #bfa14a;">
      <i class="bi bi-heart"></i>
    </button>
  </div>

  <!-- Discount Badge -->
  @if($product->previous_price && $product->price < $product->previous_price)
    @php
      $discount = (($product->previous_price - $product->price) / $product->previous_price) * 100;
    @endphp
    <div class="badge position-absolute top-0 start-0 m-2"
         style="font-size: 13px; padding: 5px 10px; background: linear-gradient(45deg, #bfa14a, #d4b35f); color: #fff; border-radius: 30px;">
      -{{ round($discount) }}%
    </div>
  @endif
</div>


          <!-- Product Info -->
          <div class="card-body text-center">
            <h6 class="card-title mb-2" style="font-size: 18px; font-weight: 700; color: #bfa14a;">
              <a href="{{ route('product_details', $product->id) }}" 
                 class="text-decoration-none"
                 style="color: #bfa14a;">
                {{ Str::limit($product->name, 45) }}
              </a>
            </h6>


            <!-- Price -->
            <div class="price-container mb-2" style="font-size: 16px;">
              @if($product->previous_price && $product->price < $product->previous_price)
                <span style="color: #bfa14a; font-weight: 700;">${{ number_format($product->price, 2) }}</span>
                <small class="text-muted text-decoration-line-through ms-1">
                  ${{ number_format($product->previous_price, 2) }}
                </small>
                <div class="mt-1">
                  <span class="badge" style="background-color: #bfa14a; color: #fff; font-size: 12px; padding: 4px 10px;">
                    {{ round($discount) }}% Off
                  </span>
                </div>
              @else
                <span style="color: #bfa14a; font-size: 1.1rem; font-weight: 700;">
                  ${{ number_format($product->price, 2) }}
                </span>
              @endif
            </div>
          </div>
        </div>
      </div>
      @endforeach
    </div>
    <!-- 🔥 View All Products Button -->
<div class="text-center mt-4">
  <a href="{{ url('/liquid') }}" class="btn btn-lg" 
     style="background-color: #FEC630; color: #fff; font-weight: 600; border-radius: 30px; padding: 10px 30px;">
    View All Products
  </a>
</div>
  </div>
</section>
<style>
/* 🔥 Default adjustments */
.product-card {
  padding: 10px !important;
  border-radius: 15px !important;
}

.product-card img {
  max-height: 250px !important;   /* chhoti image */
  object-fit: contain !important; /* image ko crop na kare */
}

.product-card .card-body {
  padding: 10px !important;       /* spacing kam */
}

.product-card .card-title {
  font-size: 16px !important;     /* title thoda chhota */
  margin-bottom: 5px !important;
}

.product-card .price-container {
  font-size: 14px !important;     /* price chhoti */
}

/* 🔥 Mobile view (576px se neeche) */
@media (max-width: 576px) {
  #productsContainer .col-lg-3 {
    width: 50% !important;        /* ek row me 2 products */
    flex: 0 0 50% !important;
    max-width: 50% !important;
  }

  .product-card img {
    max-height: 180px !important; /* mobile pe aur chhoti image */
  }

  .product-card .card-title {
    font-size: 13px !important;
    font-weight: 600 !important;
  }

  .product-card .price-container {
    font-size: 12px !important;
  }

  .product-card .badge {
    font-size: 10px !important;
    padding: 3px 6px !important;
  }

  .card-actions button {
    width: 26px !important;
    height: 26px !important;
    font-size: 12px !important;
  }
}

</style>
<section id="portfolio" class="portfolio section" id="shop" style="background-color: #fff8f0;margin-top:0px;">
  <div class="container section-title text-center" data-aos="fade-up">
    <h2 style="color: #FEC630; font-weight: 800; font-family: 'Poppins', sans-serif;"> New Arrivals</h2>
    
    

  <div class="container" style="font-family: 'Poppins', sans-serif;">
    <div class="row gy-4" data-aos="fade-up" data-aos-delay="200" id="productsContainer">
      @foreach($products as $product)
      <div class="col-lg-3 col-md-6 mb-4 product-item" data-name="{{ strtolower($product->name) }}">
        <div class="card h-100 product-card border-0 shadow-lg perfume-card"
             style="transition: transform 0.4s ease, box-shadow 0.4s ease; border-radius: 20px; background: #ffffff;">
          
          <!-- Image Section -->
        <!-- Image Section -->
<div class="position-relative overflow-hidden rounded-top" 
     style="  display: flex; justify-content: center; align-items: center;">

  <a href="{{ route('product_details', $product->id) }}" 
     class="d-block h-100 w-100" style="position: relative;">

    <img src="{{ asset($product->image) }}" 
         alt="{{ $product->name }}" 
         style="max-height: 100%; max-width: 100%; object-fit: cover; display: block; margin: auto; transition: opacity 0.3s;">

    @if($product->second_image)
    <img src="{{ asset($product->second_image) }}" 
         alt="{{ $product->name }} alternate view" 
         style=" max-width: 100%; object-fit: cover; display: block; margin: auto; position: absolute; top: 0; left: 0; right: 0; bottom: 0; opacity: 0; transition: opacity 0.3s;">
    @endif

  </a>

  <!-- Wishlist -->
  <div class="card-actions position-absolute top-0 end-0 p-2">
    <button class="btn btn-sm rounded-circle shadow-sm"
            style="background-color: #fff; border: 2px solid #bfa14a; color: #bfa14a;">
      <i class="bi bi-heart"></i>
    </button>
  </div>

  <!-- Discount Badge -->
  @if($product->previous_price && $product->price < $product->previous_price)
    @php
      $discount = (($product->previous_price - $product->price) / $product->previous_price) * 100;
    @endphp
    <div class="badge position-absolute top-0 start-0 m-2"
         style="font-size: 13px; padding: 5px 10px; background: linear-gradient(45deg, #bfa14a, #d4b35f); color: #fff; border-radius: 30px;">
      -{{ round($discount) }}%
    </div>
  @endif
</div>


          <!-- Product Info -->
          <div class="card-body text-center">
            <h6 class="card-title mb-2" style="font-size: 18px; font-weight: 700; color: #bfa14a;">
              <a href="{{ route('product_details', $product->id) }}" 
                 class="text-decoration-none"
                 style="color: #bfa14a;">
                {{ Str::limit($product->name, 45) }}
              </a>
            </h6>

            <!-- Price -->
            <div class="price-container mb-2" style="font-size: 16px;">
              @if($product->previous_price && $product->price < $product->previous_price)
                <span style="color: #bfa14a; font-weight: 700;">${{ number_format($product->price, 2) }}</span>
                <small class="text-muted text-decoration-line-through ms-1">
                  ${{ number_format($product->previous_price, 2) }}
                </small>
                <div class="mt-1">
                  <span class="badge" style="background-color: #bfa14a; color: #fff; font-size: 12px; padding: 4px 10px;">
                    {{ round($discount) }}% Off
                  </span>
                </div>
              @else
                <span style="color: #bfa14a; font-size: 1.1rem; font-weight: 700;">
                  ${{ number_format($product->price, 2) }}
                </span>
              @endif
            </div>
          </div>
        </div>
      </div>
      @endforeach
    </div>
  </div>
</section>

<style>
  .product-card:hover {
    transform: translateY(-8px) scale(1.02);
    box-shadow: 0 15px 40px rgba(191, 161, 74, 0.3) !important;
  }
  .product-card:hover .hover-image { opacity: 1 !important; }
  .product-card:hover .product-image:first-of-type { opacity: 0; }
</style>

  
</section>

<style>
  /* Search Bar Styling */
  .search-container {
    position: relative;
    width: 100%;
  }
  
  .search-input {
    padding: 12px 20px;
    border-radius: 50px;
    border: 2px solid #333; /* Darker border */
    width: 100%;
    font-size: 1rem;
    transition: all 0.3s ease;
    padding-right: 50px;
    color: #333;
    font-weight: 500;
  }
  
  .search-input:focus {
    border-color: #d63384;
    box-shadow: 0 0 0 3px rgba(214, 51, 132, 0.2);
    outline: none;
  }
  .
  
  .search-btn {
    position: absolute;
    right: 5px;
    top: 50%;
    transform: translateY(-50%);
    background: transparent;
    border: none;
    color: #333;
    font-size: 1.2rem;
    padding: 8px 15px;
    cursor: pointer;
  }
  
  /* Product Card Styling */
  .product-card {
    transition: all 0.5s cubic-bezier(0.25, 0.8, 0.25, 1);
    border-radius: 12px;
    overflow: hidden;
    border: 1px solid rgba(0,0,0,0.1);
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
  }
  
  .product-card:hover {
    transform: translateY(-10px) scale(1.02);
    box-shadow: 0 15px 30px rgba(0,0,0,0.2) !important;
  }
  
  .image-container {
    position: relative;
    overflow: hidden;
    display: flex;
    align-items: center;
    justify-content: center;
  }
  
  .product-image {
    transition: all 0.5s ease;
    position: absolute;
    width: 100%;
    height: 100%;
    object-fit: contain;
    padding: 20px;
  }
  
  .hover-image {
    opacity: 0;
  }
  
  .product-card:hover .product-image:not(.hover-image) {
    opacity: 0;
    transform: scale(0.95);
  }
  
  .product-card:hover .hover-image {
    opacity: 1;
    transform: scale(1);
  }
  
  /* If no second image, keep main image visible on hover */
  .product-card:not(:has(.hover-image)):hover .product-image {
    opacity: 1 !important;
    transform: scale(1.05) !important;
  }
  
  /* Darker text styles */
  .card-title, .card-title a {
    color: #000 !important;
    font-weight: 700;
  }
  
  .price-container .text-primary {
    color: #000 !important;
    font-weight: 700;
  }
  
  /* Larger card size */
  .perfume-card {
    /* min-height: 500px; */
  }
</style>

<script>
document.addEventListener('DOMContentLoaded', function() {
  // Search functionality
  const searchInput = document.getElementById('productSearch');
  const productItems = document.querySelectorAll('.product-item');
  
  searchInput.addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    
    productItems.forEach(item => {
      const productName = item.dataset.name;
      if (productName.includes(searchTerm)) {
        item.style.display = 'block';
      } else {
        item.style.display = 'none';
      }
    });
  });
  
  // Initialize hover effects
  const productCards = document.querySelectorAll('.product-card');
  productCards.forEach(card => {
    const hasHoverImage = card.querySelector('.hover-image') !== null;
    
    if (!hasHoverImage) {
      const mainImage = card.querySelector('.product-image');
      card.addEventListener('mouseenter', () => {
        mainImage.style.transform = 'scale(1.05)';
      });
      card.addEventListener('mouseleave', () => {
        mainImage.style.transform = 'scale(1)';
      });
    }
  });
});
</script>
    

    

 
{{-- <section id="services" class="services section section-bg dark-background" style="background-color: #111; color: #fff;">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <h2 style="color: #d4af37;">What We Offer</h2>
    <p style="color: #ccc;">Discover Captain Vape’s premium range of vaping products and accessories. From high-quality devices to exclusive e-liquids, we bring you everything you need for the ultimate vape experience.</p>
  </div><!-- End Section Title -->

  <div class="container">

    <div class="row gy-4">

      <div class="col-md-6" data-aos="fade-up" data-aos-delay="100">
        <div class="service-item d-flex position-relative h-100">
          <i class="bi bi-cloud icon flex-shrink-0" style="color: #d4af37; font-size: 2rem;"></i>
          <div>
            <h4 class="title"><a class="stretched-link" style="color: #fff;">Premium Vape Devices</a></h4>
            <p class="description" style="color: #ccc;">Choose from the latest and most reliable vape devices, offering smooth performance and unmatched style.</p>
          </div>
        </div>
      </div><!-- End Service Item -->

      <div class="col-md-6" data-aos="fade-up" data-aos-delay="200">
        <div class="service-item d-flex position-relative h-100">
          <i class="bi bi-droplet-half icon flex-shrink-0" style="color: #d4af37; font-size: 2rem;"></i>
          <div>
            <h4 class="title"><a class="stretched-link" style="color: #fff;">Exclusive E-Liquids</a></h4>
            <p class="description" style="color: #ccc;">Enjoy a wide selection of premium e-liquids in various flavors, from rich tobacco blends to fruity and dessert-inspired options.</p>
          </div>
        </div>
      </div><!-- End Service Item -->

      <div class="col-md-6" data-aos="fade-up" data-aos-delay="300">
        <div class="service-item d-flex position-relative h-100">
          <i class="bi bi-lightning-charge icon flex-shrink-0" style="color: #d4af37; font-size: 2rem;"></i>
          <div>
            <h4 class="title"><a class="stretched-link" style="color: #fff;">Coils & Pods</a></h4>
            <p class="description" style="color: #ccc;">Keep your vape fresh and smooth with our high-quality coils and pods, designed for maximum flavor and vapor production.</p>
          </div>
        </div>
      </div><!-- End Service Item -->

      <div class="col-md-6" data-aos="fade-up" data-aos-delay="400">
        <div class="service-item d-flex position-relative h-100">
          <i class="bi bi-battery-full icon flex-shrink-0" style="color: #d4af37; font-size: 2rem;"></i>
          <div>
            <h4 class="title"><a class="stretched-link" style="color: #fff;">Vape Accessories</a></h4>
            <p class="description" style="color: #ccc;">Find all the essential accessories including chargers, batteries, and stylish vape cases to complete your vaping setup.</p>
          </div>
        </div>
      </div><!-- End Service Item -->

      <div class="col-md-6" data-aos="fade-up" data-aos-delay="500">
        <div class="service-item d-flex position-relative h-100">
          <i class="bi bi-star-fill icon flex-shrink-0" style="color: #d4af37; font-size: 2rem;"></i>
          <div>
            <h4 class="title"><a class="stretched-link" style="color: #fff;">Limited Edition Products</a></h4>
            <p class="description" style="color: #ccc;">Get your hands on exclusive, limited-run devices and flavors only available at Captain Vape.</p>
          </div>
        </div>
      </div><!-- End Service Item -->

      <div class="col-md-6" data-aos="fade-up" data-aos-delay="600">
        <div class="service-item d-flex position-relative h-100">
          <i class="bi bi-truck icon flex-shrink-0" style="color: #d4af37; font-size: 2rem;"></i>
          <div>
            <h4 class="title"><a class="stretched-link" style="color: #fff;">Nationwide Delivery</a></h4>
            <p class="description" style="color: #ccc;">Enjoy fast and reliable delivery of your favorite vape products anywhere across the country.</p>
          </div>
        </div>
      </div><!-- End Service Item -->

    </div>

  </div>

</section> --}}
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">

{{-- <section id="flavor-collections" class="section py-5" style="background-color: #fff;">
  <div class="container">
    <div class="section-title text-center mb-5">
      <h2 style="color: #d4af37; font-weight: 700;">Explore Flavor Collections</h2>
      <p class="text-muted">Discover our handcrafted e-liquid flavors</p>
    </div>

    <div class="row g-4">
      <!-- Fruit Flavors -->
      <div class="col-md-3 col-6">
        <a href="/flavors/fruit" class="flavor-card d-block text-decoration-none">
          <div class="position-relative overflow-hidden rounded d-flex align-items-center justify-content-center" 
               style="height: 200px; background-color: #f8f9fa; font-size: 4rem; color: #d4af37;">
            <i class="fas fa-apple-alt"></i>
            <div class="flavor-overlay position-absolute w-100 h-100 d-flex align-items-center justify-content-center">
              <h3 class="text-white mb-0">Fruit</h3>
            </div>
          </div>
        </a>
      </div>

      <!-- Dessert Flavors -->
      <div class="col-md-3 col-6">
        <a href="/flavors/dessert" class="flavor-card d-block text-decoration-none">
          <div class="position-relative overflow-hidden rounded d-flex align-items-center justify-content-center" 
               style="height: 200px; background-color: #f8f9fa; font-size: 4rem; color: #d4af37;">
            <i class="fas fa-birthday-cake"></i>
            <div class="flavor-overlay position-absolute w-100 h-100 d-flex align-items-center justify-content-center">
              <h3 class="text-white mb-0">Dessert</h3>
            </div>
          </div>
        </a>
      </div>

      <!-- Menthol Flavors -->
      <div class="col-md-3 col-6">
        <a href="/flavors/menthol" class="flavor-card d-block text-decoration-none">
          <div class="position-relative overflow-hidden rounded d-flex align-items-center justify-content-center" 
               style="height: 200px; background-color: #f8f9fa; font-size: 4rem; color: #d4af37;">
            <i class="fas fa-leaf"></i>
            <div class="flavor-overlay position-absolute w-100 h-100 d-flex align-items-center justify-content-center">
              <h3 class="text-white mb-0">Menthol</h3>
            </div>
          </div>
        </a>
      </div>

      <!-- Tobacco Flavors -->
      <div class="col-md-3 col-6">
        <a href="/flavors/tobacco" class="flavor-card d-block text-decoration-none">
          <div class="position-relative overflow-hidden rounded d-flex align-items-center justify-content-center" 
               style="height: 200px; background-color: #f8f9fa; font-size: 4rem; color: #d4af37;">
            <i class="fas fa-smoking"></i>
            <div class="flavor-overlay position-absolute w-100 h-100 d-flex align-items-center justify-content-center">
              <h3 class="text-white mb-0">Tobacco</h3>
            </div>
          </div>
        </a>
      </div>
    </div>
  </div>
</section> --}}


<style>
  .flavor-overlay {
    background: rgba(212, 175, 55, 0.8); /* Golden transparent */
    transition: all 0.3s ease;
  }
  .flavor-card:hover .flavor-overlay {
    background: rgba(212, 175, 55, 0.95); /* Darker golden on hover */
  }
</style>

    {{-- <section id="why-choose-us" class="section py-5" style="background-color: #f8f9fa;">
  <div class="container">
    <div class="section-title text-center mb-5">
      <h2 style="color: rgb(221, 192, 75) font-weight: 700;">Why Choose Captain Vape?</h2>
      <p class="text-muted">Premium quality, unbeatable prices, and exceptional service</p>
    </div>

    <div class="row g-4">
      <!-- Feature 1 -->
      <div class="col-md-4" data-aos="fade-up">
        <div class="feature-card p-4 text-center bg-white rounded shadow-sm h-100">
          <div class="icon-wrapper mb-3" style="width: 70px; height: 70px; background: linear-gradient(135deg, #d63384, #8a2be2); border-radius: 50%; display: inline-flex; align-items: center; justify-content: center;">
            <i class="bi bi-shield-check text-white fs-3"></i>
          </div>
          <h4 style="color: #343a40;">Authentic Products</h4>
          <p class="text-muted">100% genuine vape devices and e-liquids from top brands worldwide</p>
        </div>
      </div>

      <!-- Feature 2 -->
      <div class="col-md-4" data-aos="fade-up" data-aos-delay="100">
        <div class="feature-card p-4 text-center bg-white rounded shadow-sm h-100">
          <div class="icon-wrapper mb-3" style="width: 70px; height: 70px; background: linear-gradient(135deg, #20c997, #0d6efd); border-radius: 50%; display: inline-flex; align-items: center; justify-content: center;">
            <i class="bi bi-truck text-white fs-3"></i>
          </div>
          <h4 style="color: #343a40;">Fast Shipping</h4>
          <p class="text-muted">Same-day dispatch with discreet packaging across Canada</p>
        </div>
      </div>

      <!-- Feature 3 -->
      <div class="col-md-4" data-aos="fade-up" data-aos-delay="200">
        <div class="feature-card p-4 text-center bg-white rounded shadow-sm h-100">
          <div class="icon-wrapper mb-3" style="width: 70px; height: 70px; background: linear-gradient(135deg, #fd7e14, #ffc107); border-radius: 50%; display: inline-flex; align-items: center; justify-content: center;">
            <i class="bi bi-headset text-white fs-3"></i>
          </div>
          <h4 style="color: #343a40;">Expert Support</h4>
          <p class="text-muted">Vape specialists available 7 days a week for personalized advice</p>
        </div>
      </div>
    </div>
  </div>
</section> --}}

<style>
  .feature-card {
    transition: transform 0.3s, box-shadow 0.3s;
    border: 1px solid rgba(0,0,0,0.05);
  }
  .feature-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 10px 25px rgba(0,0,0,0.1) !important;
  }
</style>
    

<style>
  /* Add to your site’s stylesheet */

.shop-categories .category-card {
  transition: transform 0.3s, box-shadow 0.3s;
  border-radius: 8px;
}
.shop-categories .category-card img {
  width: 100%;
  height: auto;
  display: block;
}
.shop-categories .category-card:hover {
  transform: translateY(-5px);
  box-shadow: 0 8px 20px rgba(0, 0, 0, 0.15);
}
.shop-categories .overlay-text {
  position: absolute;
  bottom: 0;
  left: 0;
  width: 100%;
  padding: 1rem 0;
  background: rgba(255, 255, 255, 0.85);
  text-align: center;
  font-weight: 700;
  font-size: 1rem;
  color: #333;
  text-transform: uppercase;
}
</style>    

<!-- Testimonials Section -->
{{-- <section id="testimonials" class="testimonials section" style="background-color: #000; color: #fff;">

  <!-- Section Title -->
  <div class="container section-title" data-aos="fade-up">
    <h2 style="color: #d4af37;">Testimonials</h2>
    <p style="color: #fff;">Hear from vape lovers who enjoy the Captain Vape experience</p>
  </div><!-- End Section Title -->

  <div class="container" data-aos="fade-up" data-aos-delay="100">

    <div class="swiper init-swiper">
      <script type="application/json" class="swiper-config">
        {
          "loop": true,
          "speed": 600,
          "autoplay": { "delay": 5000 },
          "slidesPerView": "auto",
          "pagination": {
            "el": ".swiper-pagination",
            "type": "bullets",
            "clickable": true
          },
          "breakpoints": {
            "320": { "slidesPerView": 1, "spaceBetween": 40 },
            "1200": { "slidesPerView": 3, "spaceBetween": 20 }
          }
        }
      </script>
      <div class="swiper-wrapper">

        <!-- Testimonial 1 -->
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <h3 style="color: #d4af37;">Jake Williams</h3>
            <h4 style="">Vape Enthusiast</h4>
            <div class="stars mb-2" style="color: #d4af37;">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-half"></i>
            </div>
            <p style="color: black">
              <i class="bi bi-quote quote-icon-left" style="color: #d4af37;"></i>
              Captain Vape's disposables are unmatched—smooth hits, great flavors, and amazing battery life!
              <i class="bi bi-quote quote-icon-right" style="color: #d4af37;"></i>
            </p>
          </div>
        </div>

        <!-- Testimonial 2 -->
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <h3 style="color: #d4af37;">Sophia Lee</h3>
            <h4 style="">Pod System User</h4>
            <div class="stars mb-2" style="color: #d4af37;">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star"></i>
            </div>
            <p style="color: black">
              <i class="bi bi-quote quote-icon-left" style="color: #d4af37;"></i>
              The vape pods deliver rich flavor every time—refilling is a breeze, and they look super sleek.
              <i class="bi bi-quote quote-icon-right" style="color: #d4af37;"></i>
            </p>
          </div>
        </div>

        <!-- Testimonial 3 -->
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <h3 style="color: #d4af37;">Carlos Ramirez</h3>
            <h4 style="color: #fff;">Hardware Collector</h4>
            <div class="stars mb-2" style="color: #d4af37;">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
            </div>
            <p>
              <i class="bi bi-quote quote-icon-left" style="color: #d4af37;"></i>
              The new mod I bought from Captain Vape is a beast—premium build, powerful performance, and eye-catching design.
              <i class="bi bi-quote quote-icon-right" style="color: #d4af37;"></i>
            </p>
          </div>
        </div>

        <!-- Testimonial 4 -->
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <h3 style="color: #d4af37;">Mia Thompson</h3>
            <h4 style="color: #fff;">Daily Vaper</h4>
            <div class="stars mb-2" style="color: #d4af37;">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-half"></i>
            </div>
            <p style="color: black">
              <i class="bi bi-quote quote-icon-left" style="color: #d4af37;"></i>
              Love the smooth throat hit and intense flavors—Captain Vape makes every puff worth it.
              <i class="bi bi-quote quote-icon-right" style="color: #d4af37;"></i>
            </p>
          </div>
        </div>

        <!-- Testimonial 5 -->
        <div class="swiper-slide">
          <div class="testimonial-item text-center">
            <h3 style="color: #d4af37;">Ethan Park</h3>
            <h4 style="color: #fff;">Cloud Chaser</h4>
            <div class="stars mb-2" style="color: #d4af37;">
              <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
            </div>
            <p>
              <i class="bi bi-quote quote-icon-left" style="color: #d4af37;"></i>
              Massive vapor production and flavor-packed hits—this is why Captain Vape is my go-to brand.
              <i class="bi bi-quote quote-icon-right" style="color: #d4af37;"></i>
            </p>
          </div>
        </div>

      </div>
      <div class="swiper-pagination"></div>
    </div>

  </div>

</section> --}}



    

 

{{-- <section id="contact" class="contact section" style="background-color: #fffaf0; padding: 80px 0; font-family: 'Poppins', sans-serif;">

  <!-- Section Title -->
  <div class="container section-title text-center" data-aos="fade-up">
    <h2 style="font-weight: 600; color: #b8860b; margin-bottom: 15px; font-size: 2.2rem;">Contact Us</h2>
    <p style="color: #8b7500; font-size: 1rem; max-width: 600px; margin: 0 auto;">Get in touch with our team for any inquiries or assistance</p>
  </div>

  <div class="container" data-aos="fade-up" data-aos-delay="100" style="margin-top: 50px;">

    <div class="row gy-4">
      <!-- Contact Info -->
      <div class="col-lg-6">
        <div class="row gy-4">

          <div class="col-lg-12">
            <div class="info-item p-4 text-center" style="background: white; border-radius: 10px; box-shadow: 0 4px 15px rgba(184,134,11,0.1); height: 100%; transition: all 0.3s ease;">
              <div class="icon-container mb-3" style="width: 50px; height: 50px; background: linear-gradient(45deg, #FFD700, #B8860B); border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; margin: 0 auto;">
                <i class="bi bi-geo-alt" style="color: white; font-size: 20px;"></i>
              </div>
              <h3 style="font-weight: 500; color: #b8860b; margin-bottom: 10px; font-size: 1.2rem;">Address</h3>
              <p style="color: #555; font-size: 0.95rem;">104 Dundas St E, Toronto, ON M5B 1C9, Canada
</p>
            </div>
          </div>

          

          <div class="col-md-6">
            <div class="info-item p-4 text-center" style="background: white; border-radius: 10px; box-shadow: 0 4px 15px rgba(184,134,11,0.1); height: 100%; transition: all 0.3s ease;">
              <div class="icon-container mb-3" style="width: 50px; height: 50px; background: linear-gradient(45deg, #FFD700, #B8860B); border-radius: 50%; display: inline-flex; align-items: center; justify-content: center; margin: 0 auto;">
                <i class="bi bi-envelope" style="color: white; font-size: 20px;"></i>
              </div>
              <h3 style="font-weight: 500; color: #b8860b; margin-bottom: 10px; font-size: 1.2rem;">Email Us</h3>
              <p style="color: #555; font-size: 0.95rem;">mycaptainvape@gmail.com</p>
            </div>
          </div>

        </div>
      </div>

      <!-- Contact Form -->
      <div class="col-lg-6">
        <form action="{{route('contact_form')}}" method="POST" class="p-4" style="background: white; border-radius: 10px; box-shadow: 0 4px 15px rgba(184,134,11,0.1);" data-aos="fade-up" data-aos-delay="500">
          @csrf
          <div class="row gy-3">

            <div class="col-md-6">
              <input type="text" name="name" class="form-control p-3" placeholder="Your Name" required style="border: 1px solid #e0d6b4; border-radius: 6px; font-size: 0.95rem;">
            </div>

            <div class="col-md-6">
              <input type="email" name="email" class="form-control p-3" placeholder="Your Email" required style="border: 1px solid #e0d6b4; border-radius: 6px; font-size: 0.95rem;">
            </div>

            <div class="col-md-12">
              <input type="text" name="subject" class="form-control p-3" placeholder="Subject" required style="border: 1px solid #e0d6b4; border-radius: 6px; font-size: 0.95rem;">
            </div>

            <div class="col-md-12">
              <textarea name="message" rows="5" class="form-control p-3" placeholder="Your Message" required style="border: 1px solid #e0d6b4; border-radius: 6px; font-size: 0.95rem;"></textarea>
            </div>

            <div class="col-md-12 text-center mt-3">
              <button class="btn py-2 px-4" style="background: linear-gradient(45deg, #FFD700, #B8860B); color: white; border: none; border-radius: 6px; font-weight: 500; font-size: 0.95rem; transition: all 0.3s;">Send Message</button>
            </div>

          </div>
        </form>
      </div>

    </div>
  </div>

  <style>
    .form-control:focus {
      border-color: #FFD700 !important;
      box-shadow: 0 0 0 0.2rem rgba(255, 215, 0, 0.25) !important;
    }
    .btn:hover {
      background: linear-gradient(45deg, #B8860B, #FFD700) !important;
      transform: translateY(-2px);
      box-shadow: 0 4px 8px rgba(184, 134, 11, 0.3);
    }
    .info-item:hover {
      transform: translateY(-5px);
      box-shadow: 0 6px 20px rgba(184,134,11,0.2) !important;
    }
  </style>

</section> --}}
<section class="social-section py-5">
  <div class="container text-center">
    <h2 class="social-heading mb-4">Join the Conversation on Social Media</h2>
    <div class="d-flex justify-content-center gap-4 social-icons">
      <a href="#" target="_blank"><i class="bi bi-facebook"></i></a>
      <a href="#" target="_blank"><i class="bi bi-instagram"></i></a>
      <a href="#" target="_blank"><i class="bi bi-twitter-x"></i></a>
      <a href="#" target="_blank"><i class="bi bi-youtube"></i></a>
      <a href="#" target="_blank"><i class="bi bi-linkedin"></i></a>
    </div>
  </div>
</section>

<style>
/* Section Background */
.social-section {
  background: #fff; 
}

/* Heading */
.social-heading {
  font-size: 28px;
  font-weight: 600;
  color: #000; /* black heading */
}

/* Social Icons */
.social-icons a {
  font-size: 20px;
  color: #fff; /* icon white */
  background: #000; /* black background */
  width: 45px;
  height: 45px;
  display: flex;
  align-items: center;
  justify-content: center;
  border-radius: 50%; /* round */
  transition: all 0.3s ease;
  text-decoration: none;
}

.social-icons a:hover {
  background: #fec630; /* orange background on hover */
  color: #000;         /* black icon on hover */
  transform: scale(1.1);
}
</style>


  </main>  


<!-- Footer Section -->
<footer class="text-dark pt-5" style="background-color: #fec630; font-family: 'Poppins', sans-serif;">
  <div class="container-fluid px-5">
    <div class="row gy-4">

      <!-- Legal Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Legal</h5>
        <ul class="list-unstyled">
          <li><a href="/privacy-policy" class="text-dark text-decoration-none d-block mb-3">Privacy Policy</a></li>
          <li><a href="/shipping-policy" class="text-dark text-decoration-none d-block mb-3">Shipping Policy</a></li>
          <li><a href="/returns-refunds" class="text-dark text-decoration-none d-block mb-3">Returns & Refunds</a></li>
          <li><a href="/terms-conditions" class="text-dark text-decoration-none d-block">Terms & Conditions</a></li>
        </ul>
      </div>

      <!-- Contact Column -->
      <div class="col-lg-4 col-md-6">
        <h5 class="fw-bold mb-3">Contact</h5>
        <p class="mb-4"><i class="bi bi-geo-alt-fill me-2"></i>104 Dundas St E, Toronto, ON M5B 1C9, Canada</p>
        <p class="mb-4"><i class="bi bi-telephone-fill me-2 "></i>416-602-1090</p>
        <p class="mb-4 "><i class="bi bi-envelope-fill me-2 "></i><a href="mailto:mycaptainvape@gmail.com" class="text-dark text-decoration-none">MYCAPTAINVAPE@gmail.COM</a></p>
      </div>

      <!-- Map Column -->
      <div class="col-lg-4 col-md-12">
        <h5 class="fw-bold mb-3">Our Location</h5>
        <div class="ratio ratio-4x3 shadow rounded" style="border: 2px solid #fff;">
          <iframe 
            src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2886.430242838252!2d-79.3743124845027!3d43.656439079121344!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x882b34d4b6b4f9c7%3A0x1234567890abcdef!2s104%20Dundas%20St%20E%2C%20Toronto%2C%20ON%20M5B%201C9!5e0!3m2!1sen!2sca!4v1699999999999!5m2!1sen!2sca" 
            width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy">
          </iframe>
        </div>
      </div>

    </div>

    <!-- Bottom Bar -->
    <div class="text-center py-3 mt-4 border-top" style="border-color: rgba(0,0,0,0.15) !important;">
      <small>© 2025 Captain Vape. All Rights Reserved.</small>
    </div>
  </div>
</footer>

<!-- Bootstrap Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">




  <!-- Scroll Top -->
  <a href="#" id="scroll-top" class="scroll-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- Vendor JS Files -->
  <script src="{{ asset('frontend/assets/vendor/bootstrap/js/bootstrap.bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/php-email-form/validate.js') }}"></script>
  <!--<script src="{{ asset('frontend/assets/vendor/aos/aos.js') }}"></script>-->
  <script src="{{ asset('frontend/assets/vendor/glightbox/js/glightbox.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/swiper/swiper-bundle.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/purecounter/purecounter_vanilla.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/imagesloaded/imagesloaded.pkgd.min.js') }}"></script>
  <script src="{{ asset('frontend/assets/vendor/isotope-layout/isotope.pkgd.min.js') }}"></script>
  
  <!-- Main JS File -->

  

</body>

</html>